<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\Template;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
use xo\message\MessageService;
use xo\cms\core\Configuration;
use xo\core\ServiceFunctionalException;
session_start ();

$requestCode = "REGISTER_NEWSLETTER_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"email",
		"reason",
		"message" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$email = null;
$reason = null;
$message = null;

$reasons = [ 
		"1" => "Je n'ai plus de mandat",
		"2" => "Je ne suis plus militant",
		"3" => "Je reçois trop d’information",
		"100" => "Autre" 
];

//NEWSLETTER TYPE
$configType=2;

if ($httpRequest->hasPostData ( "email" )) {
	$email = $httpRequest->getPostDataAsText ( "email" );
} else {
	$error = true;
	$result->message = "Le champ 'Email' n'est pas rempli.";
}
if ($httpRequest->hasPostData ( "reason" )) {
	$reason = $httpRequest->getPostDataAsText ( "reason" );
	if ($reason=="100") {
		if ($httpRequest->hasPostData ( "message" )) {
			$message = $httpRequest->getPostDataAsText ( "message" );
		} else {
			$error = true;
			$result->message = "Le champ 'Message' n'est pas rempli.";
		}
	}else{
		$message="";
	}
} else {
	$error = true;
	$result->message = "Le champ 'Raison' n'est pas rempli.";
}

if (! $error) {
	$template = new Template ( 'email', "FR", "unregister-newsletter-body" );
	$ctx = array ();
	$ctx ["email"] = $email;
	$ctx ["reason"] = $reasons [$reason];
	$ctx ["message"] = $message;
	$body = $template->renderToString ( $ctx );
	try {
		$messageService = new MessageService ( Configuration::getInstance ()->db () );
		$configurations = $messageService->getConfigurations ();
		$to = '';
		foreach ( $configurations as $config ) {
			if ($config->type->getCode () == $configType) {
				$to = $config->from;
				$emailSubject = $config->subject;
			}
		}
		$messageService->createMessage ( $configType, $to, $emailSubject, $body );
		$result->message = "Votre demande a été prise en compte.";
		$result->done = true;
	} catch ( ServiceFunctionalException $e ) {
		$result->message = $e->getFunctionalError ()->getMessage ();
	}
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 