<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\access\AccessService;
use xo\access\Access;
use xo\www\ServiceRequestUtils;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\HttpRequest;

session_start ();
$requestCode = "LOGIN";
$result = new JavaScriptRequestResultWrapper ( array (
		"login",
		"redirect" 
) );

$login = null;
$password = null;
$redirect = null;

$httpRequest = new HttpRequest ();
if ($httpRequest->hasPostData ( 'login' )) {
	$login = $httpRequest->getPostDataAsText ( 'login' );
}
if ($httpRequest->hasPostData ( 'password' )) {
	$password = $httpRequest->getPostDataAsText ( 'password' );
}
if ($httpRequest->hasPostData ( 'redirect' )) {
	$redirect = $httpRequest->getPostDataAsText ( 'redirect' );
}

$accessService = new AccessService ( Configuration::getInstance ()->db () );
try {
	
	$access = $accessService->login ( $login, $password );
	if ($access == null) {
		$result->message = "Le login et le mot de passe ne correspondent pas";
	} else {
		if ($access->getStatus () == Access::$STATUS_ACTIVE) {
			AccessService::setCurrentAccess ( $access );
			$result->message = "";
			$result->done = true;
		} else {
			$result->message = "L'accès n'est pas actif";
		}
	}
} catch ( ServiceFunctionalException $e ) {
	$result->message = $e->getFunctionalError ()->getMessage ();
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result, $redirect );
?>
