define([], function() {

    function noopListener(evt) {
	evt.preventDefault();
	evt.stopPropagation();
    }

    function ScrollFix(elt) {
	this.targetElt = elt;
	this.lastY = null;
	this.targetElt.addEventListener("touchmove", this.onMove.bind(this));
	this.targetElt.addEventListener("touchstart", this.onStart.bind(this));

    }
    ScrollFix.prototype = Object.create(Object.prototype);

    ScrollFix.prototype.onStart = function(evt) {
	this.lastY = startY = evt.touches[0].pageY;
    };
    ScrollFix.prototype.onEnd = function(evt) {
	this.lastY = null;
    };
    ScrollFix.prototype.onMove1st = function(evt) {
	evt.preventDefault();
	var endY = evt.touches[0].pageY;
	if (this.lastY !== null) {
	    var dist = endY - this.lastY;
	    var minY = 0;
	    var maxY = this.targetElt.scrollHeight - this.targetElt.offsetHeight - 1;
	    var scrollY = this.targetElt.scrollTop - dist;
	    if (scrollY < minY) {
		scrollY = 0;
	    }
	    if (scrollY > maxY) {
		scrollY = maxY;
	    }
	    this.targetElt.scrollTop = scrollY;

	}
	this.lastY = startY = event.touches[0].pageY;
    };
    ScrollFix.prototype.onMove = function(evt) {
	var endY = evt.touches[0].pageY;
	if (this.lastY !== null) {
	    var dist = endY - this.lastY;
	    var minY = 0;
	    var maxY = this.targetElt.scrollHeight - this.targetElt.offsetHeight - 1;
	    var scrollY = this.targetElt.scrollTop - dist;
	    if (scrollY < minY || scrollY > maxY) {
		evt.preventDefault();
	    }
	}
	this.lastY = startY = event.touches[0].pageY;
    };

    function ToggleButton(btnElt, targetElt) {
	this.btnElt = btnElt;
	this.targetElt = targetElt;
	new ScrollFix(this.targetElt);

    }

    ToggleButton.INSTANCES = [];

    ToggleButton.create = function(btnElt, targetElt) {
	var btn = new ToggleButton(btnElt, targetElt);
	ToggleButton.INSTANCES.push(btn);
	btn.init();
	return btn;
    }

    ToggleButton.prototype = Object.create(Object.prototype);

    ToggleButton.prototype.init = function() {
	this.btnElt.addEventListener("click", this.onclick.bind(this));
	this.closeImage = this.btnElt.getAttribute("src");
	this.openImage = this.btnElt.hasAttribute("data-open-icon") ? this.btnElt.getAttribute("data-open-icon") : this.closeImage;

    }

    ToggleButton.prototype.onclick = function(evt) {
	evt.preventDefault();
	evt.stopPropagation();
	this.toggle();

    }
    ToggleButton.prototype.hideTarget = function() {
	if (this.isTargetVisible()) {
	    /* this.targetElt.scrollTop=0; */
	    this.btnElt.src = this.closeImage;

	    document.body.classList.remove("popupOpen");
	    this.targetElt.classList.remove("visible");
	    setTimeout(function() {
		MobileUI.getInstance().checkHeaderSize();
	    }, 400);
	    this.targetElt.blur();
	    document.body.focus();
	}
    }

    ToggleButton.prototype.displayTarget = function() {
	if (!this.isTargetVisible()) {
	    this.btnElt.src = this.openImage;
	    MobileUI.getInstance().minimizeHeader(true);
	    document.body.classList.add("popupOpen");
	    this.targetElt.classList.add("visible");
	    var onPopupClick = function(evt) {
		evt.stopPropagation();
		if (this.targetElt == evt.target) {
		    this.targetElt.removeEventListener("mousedown", onPopupClick);
		    this.toggle();
		}
	    }.bind(this);
	    this.targetElt.addEventListener("click", onPopupClick);
	    this.targetElt.focus();
	}
    }
    ToggleButton.prototype.isTargetVisible = function() {
	return this.targetElt.classList.contains("visible");
    }
    ToggleButton.prototype.closeOther = function() {
	for (var i = 0; i < ToggleButton.INSTANCES.length; i++) {
	    var btn = ToggleButton.INSTANCES[i];
	    if (btn !== this) {
		btn.hideTarget();
	    }
	}

    };
    ToggleButton.prototype.toggle = function() {
	this.closeOther();
	if (this.isTargetVisible()) {
	    this.hideTarget();
	} else {
	    this.displayTarget();
	}
    }

    function MobileUI() {

    }

    // MobileUI.HEADER_HEIGHT = 180;
    // MobileUI.MINIMIZED_HEADER_HEIGHT = 64;

    // MobileUI.MINIMIZE_Y = MobileUI.HEADER_HEIGHT -
    // MobileUI.MINIMIZED_HEADER_HEIGHT - 30;

    MobileUI.MINIMIZE_Y = 120;

    // MobileUI.MINIMIZE_Y2 =MobileUI.MINIMIZED_HEADER_HEIGHT ;
    MobileUI.TOPBTN_Y = 32;

    MobileUI.prototype = Object.create(Object.prototype);

    MobileUI.INSTANCE = new MobileUI(window);

    MobileUI.getInstance = function() {
	return MobileUI.INSTANCE;
    };

    MobileUI.prototype.init = function(win) {
	this.win = win;
	win.addEventListener("scroll", this.onScroll.bind(this));
	win.addEventListener("hashchange", this.hashChange.bind(this));

	this.checkHeaderSize();
	this.win.document.body.appendChild(this.getMoveToTopButtonElt());
	this.initToggleButtons();
    };

    MobileUI.prototype.initToggleButtons = function() {
	var elts = this.win.document.querySelectorAll(".toggleBtn");
	for (var i = 0; i < elts.length; i++) {
	    var elt = elts[i];

	    if (elt.hasAttribute("data-target-id")) {
		var targetId = elt.getAttribute("data-target-id");
		var targetElt = this.win.document.getElementById(targetId);
		if (targetElt !== null && targetElt !== undefined) {
		    ToggleButton.create(elt, targetElt);
		}

	    }

	}
    };

    MobileUI.prototype.moveToTop = function(evt) {
	evt.preventDefault();
	evt.stopPropagation();
	this.minimizeHeader(true);
	this.win.scrollTo(this.win.scrollX, 0);

    };

    MobileUI.prototype.hashChange = function(evt) {
	for (var i = 0; i < ToggleButton.INSTANCES.length; i++) {
	    var btn = ToggleButton.INSTANCES[i];
	    btn.hideTarget();
	}
    }

    MobileUI.prototype.getMoveToTopButtonElt = function() {
	if (this.moveToTopButtonElt === undefined) {
	    var moveToTopButtonElt = this.moveToTopButtonElt = this.win.document.createElement("div");
	    moveToTopButtonElt.setAttribute("id", "MOVE_TO_TOP_BTN");
	    moveToTopButtonElt.style.display = "none";
	    moveToTopButtonElt.addEventListener("click", this.moveToTop.bind(this));
	}
	return this.moveToTopButtonElt;
    }
    MobileUI.prototype.checkHeaderSize = function() {
	var scroll = this.win.scrollY;
	if (this.isHeaderMinimized()) {
	    if (scroll < MobileUI.MINIMIZE_Y) {
		this.minimizeHeader(false);

	    } else {
		this.minimizeHeader(true);
	    }
	} else {
	    if (scroll > MobileUI.MINIMIZE_Y) {
		this.minimizeHeader(true);
	    } else {
		this.minimizeHeader(false);
	    }
	}

	if (scroll > MobileUI.TOPBTN_Y) {
	    this.getMoveToTopButtonElt().style.display = "";
	} else {
	    this.getMoveToTopButtonElt().style.display = "none";
	}
    }
    MobileUI.prototype.onScroll = function(evt) {
	this.checkHeaderSize();

    };

    MobileUI.prototype.isPopupOpen = function() {
	for (var i = 0; i < ToggleButton.INSTANCES.length; i++) {
	    var btn = ToggleButton.INSTANCES[i];
	    if (btn.isTargetVisible()) {
		return true;
	    }
	}

	return false;
    };
    MobileUI.prototype.isHeaderMinimized = function() {
	return this.win.document.body.classList.contains("minimized-header");
    };

    MobileUI.prototype.minimizeHeader = function(minimize) {
	if (minimize) {
	    if (!this.isHeaderMinimized()) {
		this.win.document.body.classList.add("minimized-header");

	    }
	} else {
	    if (this.isHeaderMinimized()) {
		this.win.document.body.classList.remove("minimized-header");

	    }
	}
    }

    return {
	"MobileUI" : MobileUI
    };
});