define(function() {
	function Carrousel(containerElt, items) {
		this.active = true;
		this.container = containerElt;
		this.currentIdx = 0;
		this.items = items;
		this.delay = 3000;
		this.count = 0;
		this.mouseOverElt = null;
		this.itemCount=6;
	}
	Carrousel.prototype = Object.create(Object.prototype);

	Carrousel.prototype.start = function() {
		addEventListener("mouseover", function(e) {
			this.mouseOverElt = e.target;
		}.bind(this));
		this.next();

	};
	Carrousel.prototype.isActive = function() {
		return this.active;
	};
	
	
	Carrousel.prototype.next = function() {
		if (this.isActive()) {
			var displays = [];
			for (var i = 0; i < this.items.length; i++) {
				displays.push(false);
				var img = this.items.item(i).querySelector("img[data-src]");
				if (img !== null && img !== undefined) {
					img.setAttribute("src", img.getAttribute("data-src"));
				}
			}
			for (var i = 0; i < this.itemCount; i++) {
				displays[(this.count + i) % this.items.length] = true;
			}
			for (var i = 0; i < this.items.length; i++) {
				this.items.item(i).style.display = displays[i] ? "" : "none";
			}

			this.count = (this.count + this.itemCount) % this.items.length;

		}
		setTimeout(this.next.bind(this), this.delay);
	};


	return {
		"Carrousel" : Carrousel
	}

});