define(function() {
    function Carrousel(items) {
	this.isActive = true;
	this.currentIdx = 0;
	this.items = items;
	this.delay = 4000;
	for (var i = 0; i < items.length; i++) {
	    var item = items.item(i);
	    // item.addEventListener("click", this.select.bind(this, i));
	    if (item.classList.contains("selected")) {
		this.currentIdx = i;
	    }
	}
    }
    Carrousel.prototype = Object.create(Object.prototype);

    Carrousel.prototype.start = function() {
	this.setCurrentItem(this.currentIdx);
	setTimeout(this.next.bind(this), this.delay);
    };

    Carrousel.prototype.next = function() {
	if (this.isActive) {
	    var nextIdx = (this.currentIdx + 1) % this.items.length;
	    this.setCurrentItem(nextIdx);
	    setTimeout(this.next.bind(this), this.delay);
	}
    };

    Carrousel.prototype.setCurrentItem = function(idx) {
	this.items.item(this.currentIdx).classList.remove("selected");
	this.currentIdx = idx;
	this.items.item(this.currentIdx).classList.add("selected");
    }
    Carrousel.prototype.select = function(idx) {
	this.setCurrentItem(idx);
	this.stop();
    }
    Carrousel.prototype.selectPrevious = function() {
	this.setCurrentItem((this.currentIdx - 1 + this.items.length) % this.items.length);
	this.stop();
    }
    Carrousel.prototype.selectNext = function() {
	this.setCurrentItem((this.currentIdx + 1) % this.items.length);
	this.stop();
    }

    Carrousel.prototype.stop = function() {
	this.isActive = false;
    };

    return {
	"Carrousel" : Carrousel
    }

});