<?php 

//dependencies
require_once '../../../../configuration/config.inc.php';
session_start();
require_once 'web/package.inc.php';
require_once 'profile/package.inc.php';

if(!ServiceRequestUtils::checkAuthorization('MANAGE_PROFILE')){

	exit(0);

}


$requestCode="CREATE_PROFILE_ADDRESS";
$result=new JavaScriptRequestResultWrapper(array('address1','address2','address3',
		'address4','zip','city','country'));

$httpRequest=new HttpRequest();
$profileId=null;
if($httpRequest->hasPostData("profile-id")){
	$profileId=$httpRequest->getPostDataAsInteger("profile-id");
}
if($profileId==null){
	//TODO
}

$error=false;
$address=new Address();
if($httpRequest->hasPostData("address1")){

	$address->setAddress1($httpRequest->getPostDataAsText("address1"));

}else{
	$result->message.='Le champ adresse n\'est pas rempli.';
	$error=true;
}
if($httpRequest->hasPostData("address2")){

	$address->setAddress2($httpRequest->getPostDataAsText("address2"));

}
if($httpRequest->hasPostData("address3")){

	$address->setAddress3($httpRequest->getPostDataAsText("address3"));

}
if($httpRequest->hasPostData("address4")){

	$address->setAddress4($httpRequest->getPostDataAsText("address4"));

}

if($httpRequest->hasPostData("zip")){

	$address->setZipCode($httpRequest->getPostDataAsText("zip"));

}else{
	$result->message.='Le champ code postal n\'est pas rempli.';
	$error=true;
}

if($httpRequest->hasPostData("city")){

	$address->setCity($httpRequest->getPostDataAsText("city"));

}else{
	$result->message.='Le champ ville n\'est pas rempli.';
	$error=true;
}

if($httpRequest->hasPostData("country")){

	$address->setCountry($httpRequest->getPostDataAsText("country"));

}else{
	$result->message.='Le champ pays n\'est pas rempli.';
	$error=true;
}
if(!$error){
	try{

		$service=new ProfileService(getWebControllerDB());
		$service->createProfileAddress($profileId,$address);

		$result->message="Les changements ont bien été pris en compte";

		$result->done=true;

	}catch(ServiceFunctionalException $e){

		$result->message=$e->getFunctionalError()->getMessage();

	}catch(Exception $e){
		$result->message="Une erreur est survenue lors de la mise à jour de l'adresse";
		error_log("EXCEPTION ...".$e->getMessage());
	}
}
ServiceRequestUtils::setRequestResult($requestCode, $result);
?>