<?php

// dependencies
require_once '../../../../configuration/config.inc.php';

use xo\cms\core\Configuration;
use xo\profile\ProfileService;
use xo\profile\PersonProfile;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_PROFILE' )) {
	exit ( 0 );
}

$requestCode = "CREATE_ACCESS_PROFILE";
$result = new JavaScriptRequestResultWrapper ( array (
		'name',
		'firstname',
		'email',
		'phone',
		'mobile' 
) );

$httpRequest = new HttpRequest ();

$error = false;
$accessId = null;
if ($httpRequest->hasPostData ( "access-id" )) {
	$accessId = $httpRequest->getPostDataAsInteger ( "access-id" );
}
if ($accessId == null) {
	// TODO
}
$service = new ProfileService ( Configuration::getInstance ()->db () );
$profileId = $service->getAccessProfileId ( $accessId );

if ($profileId != null) {
	ServiceRequestUtils::sendMovedPermanentlyRedirectHeader ( "/modules/profiles/profile?profile-id=" . $profileId );
	
	exit ( 0 );
}

$profile = new PersonProfile ();
if ($httpRequest->hasPostData ( "firstname" )) {
	$profile->setFirstName ( $httpRequest->getPostDataAsText ( "firstname" ) );
} else {
	$result->message .= 'Le champ "Prénom" n\'est pas rempli.';
	$error = true;
}
if ($httpRequest->hasPostData ( "name" )) {
	
	$profile->setName ( $httpRequest->getPostDataAsText ( "name" ) );
} else {
	
	$result->message .= 'Le champ "Nom" n\'est pas rempli.';
	
	$error = true;
}
if ($httpRequest->hasPostData ( "email" )) {
	
	$profile->setEmail ( $httpRequest->getPostDataAsText ( "email" ) );
} else {
	
	$result->message .= 'Le champ "Email" n\'est pas rempli.';
	
	$error = true;
}
if ($httpRequest->hasPostData ( "phone" )) {
	
	$profile->setPhone ( $httpRequest->getPostDataAsText ( "phone" ) );
} else {
	
	$result->message .= 'Le champ "Téléphone" n\'est pas rempli.';
	
	$error = true;
}
if ($httpRequest->hasPostData ( "mobile" )) {
	$profile->setMobile ( $httpRequest->getPostDataAsText ( "mobile" ) );
}
if (! $error) {
	try {
		$service->createAccessProfile ( $accessId, $profile );
		$result->message = "Le profil a bien été créé";
		$result->done = true;
	} catch ( ServiceFunctionalException $e ) {
		$result->message = $e->getFunctionalError ()->getMessage ();
	} catch ( Exception $e ) {
		$result->message = "Une erreur est survenue lors de la mise à jour de l'adresse";
		error_log ( "EXCEPTION ..." . $e->getMessage () );
	}
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?>