<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

// check authorization
// read dto
$requestCode = "UPDATE_WEBPAGE_SEO_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"title",
		"image",
		"description" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$id = null;
$title = null;
$image = null;
$description = null;
$contentService = new ContentService ( Configuration::getInstance () );
$resource = null;
if ($httpRequest->hasPostData ( "id" )) {
	$idStr = $httpRequest->getPostDataAsText ( "id" );
	$id = hex2bin ( $idStr );
	$resource = $contentService->getResource ( $id );
	if ($resource == null) {
		$error = true;
		$result->message .= 'Aucune ressource ne correspond à l\'identifiant : $idStr.';
	}
} else {
	$error = true;
	$result->message .= 'Le champ "Identifiant" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "title" )) {
	$title = $httpRequest->getPostDataAsText ( "title" );
}
if ($httpRequest->hasPostData ( "description" )) {
	$description = $httpRequest->getPostDataAsText ( "description" );
}
if ($httpRequest->hasPostData ( "image" )) {
	$imageId = $httpRequest->getPostDataAsText ( "image" );
	$image = $contentService->getResource ( hex2bin ( $imageId ) );
}

if (! $error) {
	$resource->seoTitle = $title;
	$resource->seoDescription = $description;
	$resource->seoImage = $image;
	$resource = $contentService->updateWebPageSEO ( $resource );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 