<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

// check authorization
// read dto
$requestCode = "UPDATE_RESOURCE_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"name",
		"comment",
		"description" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$id = null;
$name = null;
$comment = null;
$description = null;
$contentService = new ContentService ( Configuration::getInstance () );
$resource = null;
if ($httpRequest->hasPostData ( "id" )) {
	$idStr = $httpRequest->getPostDataAsText ( "id" );
	$id = hex2bin ( $idStr );
	$resource = $contentService->getResource ( $id );
	if ($resource == null) {
		$error = true;
		$result->message .= 'Aucune ressource ne correspond à l\'identifiant : $idStr.';
	}
} else {
	$error = true;
	$result->message .= 'Le champ "Identifiant" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "name" )) {
	$name = $httpRequest->getPostDataAsText ( "name" );
}
if ($httpRequest->hasPostData ( "comment" )) {
	$comment = $httpRequest->getPostDataAsText ( "comment" );
}
if ($httpRequest->hasPostData ( "description" )) {
	$description = $httpRequest->getPostDataAsText ( "description" );
}
if (! $error) {
	$resource->comment=$comment;
	$resource->description=$description;
	$resource->name=$name;
	$resource = $contentService->updateResource ( $resource );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 