<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

// check authorization
// read dto
$requestCode = "UPDATE_RESOURCE_MAP_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"path",
		"online" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$id = null;
$path = null;
$online = null;
$create = true;

if ($httpRequest->hasPostData ( "pathId" )) {
	$id = hex2bin ( $httpRequest->getPostDataAsText ( "pathId" ) );
} else {
	$error = true;
	$result->message .= 'Le champ "Ressource" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "path" )) {
	$path = $httpRequest->getPostDataAsText ( "path" );
} else {
	$error = true;
	$result->message .= 'Le champ "Chemin" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "online" )) {
	$online = true;
} else {
	$online = false;
}
if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->updateResourceMap ( $id, $path, $online );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 