<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

// check authorization
// read dto
$requestCode = "UPDATE_RESOURCE_DATA_FORM";
$result = new JavaScriptRequestResultWrapper ( array () );

$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$id = null;
$content = null;
$contentType = null;

if ($httpRequest->hasPostData ( "resourceId" )) {
	$id = hex2bin ( $httpRequest->getPostDataAsText ( "resourceId" ) );
} else {
	$error = true;
	$result->message .= 'Le champ "Ressource" n\'est pas rempli.';
}

if (! empty ( $_FILES ["contentFile"] ["name"] )) {
	$file = $_FILES ["contentFile"];
	if ($file ["error"] == UPLOAD_ERR_OK) {
		$content = file_get_contents ( $file ["tmp_name"] );
	} else {
		$error = true;
	}
} elseif ($httpRequest->hasPostData ( "contentURL" )) {
	$url = $httpRequest->getPostDataAsText ( "contentURL" );
	$content = file_get_contents ( $url );
} elseif ($httpRequest->hasPostData ( "content" )) {
	$content = $httpRequest->getPostDataAsHTML ( "content" );
	$contentType = "text/html";
}
if (empty ( $content )) {
	$error = true;
	$result->message .= 'Le champ "Contenu" n\'est pas rempli.';
}

if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->updateResourceData ( $id, $content, $contentType );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 