<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

$requestCode = "UPDATE_LIST_ITEM_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
	
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$id = null;

if ($httpRequest->hasPostData ( "id" )) {
	$idStr = $httpRequest->getPostDataAsText ( "id" );
	$requestCode .= strtoupper ( $idStr );
	$id = hex2bin ( $idStr );
}

if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	$item = $contentService->getListItem ( $id );
	if ($item->deleted) {
		$contentService->unTrashItem($item);
	} else {
		$contentService->trashItem($item);
	}
	
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 