<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->getCurrentResource ( $idBin );
	if ($resource != null) {
		if ($resource->preview->id == null) {
			$contentType = $contentService->getData ( $resource->data->id )->contentType;
			switch ($contentType) {
				case 'text/html' :
					$content = base64_decode ( "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" );
					break;
				case 'application/pdf' :
					$content = base64_decode ( "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" );
					break;
				default :
					$content = base64_decode ( "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AUREQoFbbTb6gAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAADtSURBVHja7dIBDQAACMMwwL/nY4OEVsKyTlL8NRIYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEMIIEBMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMwA0L7XcD/RiEY4cAAAAASUVORK5CYII" );
			}
			$md5 = base64_encode ( md5 ( $content, true ) );
			$filename = "preview-" . bin2hex ( $resource->id ) . ".png";
			header ( "Content-Type:image/png" );
			error_log ( "Content-Disposition:inline; filename='$filename'" );
			header ( "Content-Disposition:inline; filename='$filename'" );
			header ( "Content-MD5:$md5" );
			echo $content;
		} else {
			$md5 = base64_encode ( $resource->preview->md5 );
			$date = gmdate ( "D, d M Y H:i:s", $resource->preview->date ) . " GMT";
			header ( "Content-Type:{$resource->preview->contentType}" );
			header ( "Date:$date" );
			header ( "Content-Type:{$resource->preview->contentType}" );
			header ( "Content-Encoding:{$resource->preview->encoding}" );
			header ( "Content-Disposition:inline; filename={$resource->preview->filename}" );
			header ( "Content-MD5:$md5" );
			$out = fopen ( "php://output", 'r+' );
			$contentService->writeResourceData ( $out, $resource->preview );
		}
	} else {
		header ( "Status: 404 Not Found", false, 404 );
	}
} else {
	header ( "Status: 404 Not Found", false, 404 );
}
?>