<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

// check authorization
// read dto
$requestCode = "CREATE_WEBPAGE_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"name",
		"template" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$locale = null;
$template = null;
$name = null;

if ($httpRequest->hasPostData ( "locale" )) {
	$locale = $httpRequest->getPostDataAsText ( "locale" );
} else {
	$locale = "FR";
}
if ($httpRequest->hasPostData ( "name" )) {
	$name = $httpRequest->getPostDataAsText ( "name" );
} else {
	$error = true;
	$result->message .= 'Le champ "Nom" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "template" )) {
	$template = $httpRequest->getPostDataAsText ( "template" );
} else {
	$error = true;
	$result->message .= 'Le champ "Template" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "path" )) {
	$path = $httpRequest->getPostDataAsText ( "path" );
} else {
	$error = true;
	$result->message .= 'Le champ "Chemin" n\'est pas rempli.';
}
if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->createWebPage( $locale, $name,$path, $template);
	if ($resource == null) {
		$error = true;
		$result->message = "Erreur lors de la création de la ressource.\nVeuillez réessayer ultérieurement.";
	} else {
		$result->done = true;
		$result->message = "La page a bien été créée.";
	}
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 