<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

$requestCode = "CREATE_RESOURCEREF_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"url",
		"resourceId" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();
$redirect = null;
$url = null;
$resourceId = null;

if ($httpRequest->hasPostData ( "url" )) {
	$url = $httpRequest->getPostDataAsText ( "url" );
}
if ($httpRequest->hasPostData ( "resourceId" )) {
	$resourceId = hex2bin ( $httpRequest->getPostDataAsText ( "resourceId" ) );
}
if ($httpRequest->hasPostData ( "pageId" )) {
	$resourceId = hex2bin ( $httpRequest->getPostDataAsText ( "pageId" ) );
}
if ($url == null && $resourceId == null) {
	$error = true;
	$result->message .= 'Un des champs "URL, Page du site ou Ressource du site" doit être rempli.';
}
if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	if ($url != null) {
		$ref = $contentService->createResourceRefFromURL ( $url );
	} else {
		$ref = $contentService->createResourceRefFromResourceId ( $resourceId );
	}
	
	if ($ref == null) {
		$error = true;
		$result->message = "Erreur lors de la création du lien.\nVeuillez réessayer ultérieurement.";
	} else {
		$result->done = true;
		$result->message = "Le lien a bien été créé.";
		$redirect = "/modules/content/resourceref/?id=" . bin2hex ( $ref->id );
	}
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result, $redirect );
?> 