<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

$requestCode = "CREATE_RESOURCE_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"content" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

if ($httpRequest->hasPostData ( "locale" )) {
	$locale = $httpRequest->getPostDataAsText ( "locale" );
} else {
	$locale = "FR";
}

$contentURI = null;
if (! empty ( $_FILES ["contentFile"] ["name"] )) {
	$file = $_FILES ["contentFile"];
	if ($file ["error"] == UPLOAD_ERR_OK) {
		$contentURI = $file ["tmp_name"];
		$name = basename ( $file ["name"] );
	} else {
		$error = true;
	}
} elseif ($httpRequest->hasPostData ( "contentURL" )) {
	$url = $_POST ["contentURL"];
	$contentURI = $url;
	$name=basename(parse_url($url, PHP_URL_PATH));
	echo $name;
}
if (empty ( $contentURI )) {
	$error = true;
	$result->message .= 'Le champ "Contenu" n\'est pas rempli.';
}

if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->createResource ( $locale, $name,file_get_contents($contentURI)  );
	if ($resource == null) {
		$error = true;
		$result->message = "Erreur lors de la création de la ressource.\nVeuillez réessayer ultérieurement.";
	} else {
		$result->done = true;
		$result->message = "La ressource a bien été créée.";
	}
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 