<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

$requestCode = "ADD_LIST_ITEM_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"key",
		"type",
		"resourceId",
		"resourceRefId",
		"subListId",
		"textContent" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$count = 0;
$key = null;
$idx = 0;
$resourceId = null;
$resourceRefId = null;
$newList = null;
$listId = null;
$textContent = null;
$subListId=null;
if ($httpRequest->hasPostData ( "listId" )) {
	$listId = hex2bin ( $httpRequest->getPostDataAsText ( "listId" ) );
} else {
	$error = true;
	$result->message .= 'Le champ "Liste ID" doit être rempli.';
}
if ($httpRequest->hasPostData ( "key" )) {
	$key = $httpRequest->getPostDataAsText ( "key" );
}
if ($httpRequest->hasPostData ( "idx" )) {
	$idx = $httpRequest->getPostDataAsInteger ( "idx" );
}
if ($httpRequest->hasPostData ( "resourceId" )) {
	$resourceId = hex2bin ( $httpRequest->getPostDataAsText ( "resourceId" ) );
	$count ++;
}
if ($httpRequest->hasPostData ( "resourceRefId" )) {
	$resourceRefId = hex2bin ( $httpRequest->getPostDataAsText ( "resourceRefId" ) );
	$count ++;
}
if ($httpRequest->hasPostData ( "newList" )) {
	$subListId = ContentService::uuid ();
	$count ++;
}
if ($httpRequest->hasPostData ( "textContent" )) {
	$textContent = $httpRequest->getPostDataAsHTML ( "textContent" );
	$count ++;
}
if ($count == 0) {
	$error = true;
	$result->message .= 'Un des champs "Ressource, Lien ou Liste" doit être rempli.';
} else {
	if ($count > 1) {
		$error = true;
		$result->message .= 'Un seul des champs "Ressource, Lien ou Liste" doit être rempli.';
	}
}

if (! $error) {
	$contentService = new ContentService ( Configuration::getInstance () );
	if ($resourceId !== null) {
		$item = $contentService->addResourceItem ( $listId, $idx, $key, $resourceId );
	}
	if ($resourceRefId !== null) {
		$item = $contentService->addResourceRefItem ( $listId, $idx, $key, $resourceRefId );
	}
	if ($subListId !== null) {
		$item = $contentService->addListItem ( $listId, $idx, $key, $subListId );
	}
	if ($textContent !== null) {
		$item = $contentService->addTextItem ( $listId, $idx, $key, $textContent );
	}
	if ($item == null) {
		$error = true;
		$result->message = "Erreur lors de la création de la ressource.\nVeuillez réessayer ultérieurement.";
	} else {
		$result->done = true;
		$result->message = "La ressource a bien été créée.";
	}
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 