<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_ACCESS' )) {
	
	exit ( 0 );
}
$requestCode = "UPDATE_ACCESS_STATUS";
$result = new JavaScriptRequestResultWrapper ( array () );

$login = null;
$password = null;

$httpRequest = new HttpRequest ();
if ($httpRequest->hasPostData ( 'access-id' )) {
	
	$accessId = $httpRequest->getPostDataAsInteger ( 'access-id' );
}
if ($httpRequest->hasPostData ( 'status' )) {
	$status = $httpRequest->getPostDataAsInteger ( 'status' );
}
$accessService = new AccessService ( Configuration::getInstance ()->db () );

try {
	$accessService->updateAccessStatus ( $accessId, $status );
	$result->message = "Les changements ont bien été pris en compte";
	
	$result->done = true;
} catch ( ServiceFunctionalException $e ) {
	$result->message = $e->getFunctionalError ()->getMessage ();
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?>