<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_ACCESS' )) {
	
	exit ( 0 );
}
$requestCode = "UPDATE_ACCESS_PASSWORD";
$result = new JavaScriptRequestResultWrapper ( array () );

$login = null;
$password = null;

$httpRequest = new HttpRequest ();
if ($httpRequest->hasPostData ( 'access-id' )) {
	$accessId = $httpRequest->getPostDataAsInteger ( 'access-id' );
}
if ($httpRequest->hasPostData ( 'password1' )) {
	$password1 = $httpRequest->getPostDataAsText ( "password1" );
}
if ($httpRequest->hasPostData ( 'password2' )) {
	$password2 = $httpRequest->getPostDataAsText ( "password2" );
}

$accessService = new AccessService ( Configuration::getInstance ()->db () );

if (empty ( $password1 )) {
	$result->message = "Le mot de passe doit être précisé";
} else {
	if ($password1 != $password2) {
		$result->message = "Les 2 mots de passe ne correspondent pas";
	} else {
		try {
			$accessId = $accessService->updateAccessPassword ( $accessId, $password1 );
			$result->message = "Le mot de passe a bien été mis à jour";
			$result->done = true;
		} catch ( ServiceFunctionalException $e ) {
			$result->message = $e->getFunctionalError ()->getMessage ();
		}
	}
}

ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?>