<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\message\MessageService;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_MESSAGE', false )) {
	exit ( 0 );
}
$title = 'Administration - Messages';
$messagesService = new MessageService ( Configuration::getInstance ()->db () );
$messageTypes = $messagesService->getMessageTypes ( 'FR' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <?php include '../../html-headers.tpl.php'; ?>
        <link href="/style/message/select-type.css" media="all" rel="stylesheet" type="text/css" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1>
			<?=$title?>
		</h1>
		<?php
		$typeCode = null;
		$message = null;
		include '../menu.tpl.php';
		?>
		 <form action="/modules/message/messages-by-type/" method="get">
			<fieldset class="fields">
				<legend>Choix du type de message</legend>
				<div class="line">
					<label class="label">Type : </label> <select class="field" name="type">
							<?php  foreach ($messageTypes as $type) { ?>
                                    <option value="<?= $type->getCode() ?>">  <?= $type->getLabel()?> </option>
                                <?php } ?>
                    </select> <input class="submit" type="submit" value="Envoyer" />
				</div>
			</fieldset>
		</form>

	</div>

</body>
</html>
