<?php
require_once '../../../../configuration/config.inc.php';

use xo\cms\core\Configuration;
use xo\message\MessageService;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_MESSAGE', false )) {
	exit ( 0 );
}
if (! array_key_exists ( "id", $_GET )) {
	exit ( 0 );
}
$id = $_GET ['id'];
$title = 'Administration - Messages';
$messagesService = new MessageService ( Configuration::getInstance ()->db () );
$message = $messagesService->getMessageById ( $id );
if ($message == null) {
	exit ( 0 );
}

$messageType = $messagesService->getMessageTypeByCode ( $message->typeCode );
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <?php include '../../html-headers.tpl.php'; ?>
        <link href="/style/message/message.css" media="all" rel="stylesheet" type="text/css" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1>
			<?=$title?>
		</h1>
		<?php
		$typeCode = null;
		
		include '../menu.tpl.php';
		?>
		<fieldset class="message">
			<div class="head">
				<p>
					De : <a class="email" href="mailto:<?=$message->email?>"><?=$message->email?></a>
				</p>
				<p>
					Reçu le <span class="date"><?=$message->date?></span>
				</p>
			</div>
			<h2 class="title"><?=$message->title?></h2>
			<div class="content"><?=$message->content?></div>
		</fieldset>
		<?php
		if (count ( $message->getAttachments () ) > 0) {
			?>
		<fieldset class="attachments">
			<legend>Pièces jointes</legend>
			<?php foreach($message->getAttachments() as $attachment){?>
			<a class="attachment" href="/modules/message/attachment?id=<?=$attachment->dataId?>"><?=$attachment->name?></a>
			<?php } ?>
		</fieldset>
		<?php }?>

	</div>

</body>
</html>
