<?php
require_once '../../../../configuration/config.inc.php';
use xo\message\MessageService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_MESSAGE', false )) {
	exit ( 0 );
}
$title = 'Administration - Configuration';
$messagesService = new MessageService ( Configuration::getInstance ()->db () );
$configurations = $messagesService->getConfigurations ();

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <?php include '../../html-headers.tpl.php'; ?>
        <link href="/style/message/configuration.css" media="all" rel="stylesheet" type="text/css" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1>
			<?=$title?>
		</h1>
		<?php 
		$typeCode=null;
		$message=null;
		include '../menu.tpl.php'; 
		?>
		<?php foreach($configurations as $config){?>
		<fieldset>
			<legend><?= $config->type->getLabel() ?></legend>
			<form method="post" action="/system/service/message/update-service-config.php" id="UPDATE_MESSSAGE_CONFIG">
				<div class="line">
					<label class="label">Email d'envoi</label> <input value="<?=htmlentities($config->from)?>" class="field" type="email" name="from" />
				</div>
				<div class="line">
					<label class="label">Nom de l'envoyeur</label> <input value="<?=htmlentities($config->sender)?>" class="field" name="sender" />
				</div>
				<div class="line">
					<label class="label">Titre de l'email</label> <input value="<?=htmlentities($config->subject)?>" class="field" type="text" name="subject" />
				</div>
				<div class="line">
					<label class="label">CC</label>
					<textarea class="field" name="cc"><?=htmlentities($config->cc)?></textarea>
				</div>
				<div class="line">
					<label class="label">BCC</label>
					<textarea class="field" name="bcc"><?=htmlentities($config->bcc)?></textarea>
				</div>
				<div class="line submit">
					<input type="submit" value="Modifier" /> <input type="hidden" name="id" value="<?=$config->id?>" />
				</div>
			</form>
		</fieldset>
		<?php }?>
		
	</div>
</body>
</html>
