<?php
require_once '../../../../configuration/config.inc.php';
session_start ();
require_once 'web/package.inc.php';
require_once 'message/package.inc.php';
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_MESSAGE', false )) {
	exit ( 0 );
}
if (! array_key_exists ( "id", $_GET )) {
	exit ( 0 );
}
$id = $_GET ['id'];
$messagesService = new MessageService ( Configuration::getInstance()->db() );
$messageAttachment = $messagesService->getMessageAttachment ( $id );
if ($messageAttachment != null) {
	$file = DATA_PATH . $messagesService->getAttachmentPath ( $messageAttachment );
	header ( "ContentType:$messageAttachment->contentType" );
	header ( "Content-Disposition: attachment; filename=$messageAttachment->fileName;" );
	echo file_get_contents ( $file );
} else {
	header ( "HTTP/1.0 404 Not Found" );
}

?>
