<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\content\ContentService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;
use xo\cms\Pagging;
use xo\www\HttpRequest;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Gestion des liens';
$service = new ContentService ( Configuration::getInstance () );
$limit = 20;
$count = $service->getResourceRefsCount ();
$pagging = new Pagging ( $count, $limit );
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "p" )) {
	$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
	if ($currentPage < 0) {
	} elseif ($currentPage > $pagging->lastPage ()) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p={$pagging->lastPage ()}" );
		exit ();
	} else {
		$pagging->setPage ( $currentPage );
	}
} else {
	$pagging->setPage ( 0 );
}
$items = $service->getResourceRefs ( $pagging->offset (), $limit );

?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/content/resources.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Liste des liens (<?=$count?>) :</legend>
			<table class="table">
				<thead>
					<tr>
					<th>Nom</th>
						<th>Lien</th>
						<th>Commentaire</th>
						<th></th>
					</tr>
				</thead>
				<tbody>
				<?php foreach ($items as $item){?>
					<tr>
					<td><?=htmlentities($item->label)?></td>
						<td><a target="_BLANK" href="<?=$item->url?>"><?=$item->url?></a></td>
						<td><?=htmlentities($item->comment)?></td>
						<td><form action="/modules/content/resourceref">
								<input name="id" type="hidden" value="<?=bin2hex($item->id)?>" /><input type="submit" value="Editer" />
							</form></td>
					</tr>
				<?php }?>
				
				</tbody>
			</table>
				<?php if($pagging->lastPage()>0){?>
			<div class="pagging">
		<?php if($pagging->previousPage !==null){?>
		<a href="?p=<?=$pagging->previousPage?>">&lt;</a>
		<?php }?>
		<?php foreach($pagging->pages as $page){ ?>
		<span class="pageLinks"><a <?=$page==$pagging->page?'class="selected"':'' ?> href="?p=<?=$page?>"><?=$page?></a></span>
		<?php }?>
		<?php if($pagging->nextPage!==null){?>
		<a href="?p=<?=$pagging->nextPage?>">&gt;</a>
		<?php }?>
			</div>
		<?php }?>
		</fieldset>
		<fieldset> 
			<legend>Créer un nouveau lien</legend>
			<form id="CREATE_RESOURCEREF_FORM" method="POST" action="/system/service/content/create-resourceref.php">
				<fieldset>
					<legend>Cible : </legend>
					<div>
						<label>une URL externe : </label><input name="url" type="text" />
					</div>
					<div>
						<label>ou une page du site : </label><input readonly="readonly" onclick="chooseWebPage(function(id){this.value=id}.bind(this));" name="pageId" type="text" pattern="[a-f0-9]{32}" />
					</div>
					<div>
						<label>ou une ressource du site : </label><input readonly="readonly" onclick="chooseResource(function(id){this.value=id}.bind(this));" name="resourceId" type="text" pattern="[a-f0-9]{32}" />
					</div>
					
				</fieldset>
				<div>
					<input type="submit" value="Créer" />
				</div>
			</form>
		</fieldset>
	</div>
</body>
</html>
