<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\cms\ResourceRef;
use xo\cms\WebPage;
use xo\cms\WebSite;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\ServiceRequestUtils;

session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Editer un lien';
$service = new ContentService ( Configuration::getInstance () );

$httpRequest = new HttpRequest ();

if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	$ref = $contentService->getResourceRef ( $idBin );
	if ($ref === null) {
		header ( "Status: 404 Not Found", false, 404 );
		exit ();
	}
} else {
	header ( "Status: 404 Not Found", false, 404 );
	exit ();
}

?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<script type="text/javascript" src="/script/ckeditor/ckeditor.js"></script>
<link type="text/css" href="/style/content/resource.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Identifiant :</legend>
			<div><?=bin2hex($ref->id)?></div>
		</fieldset>
	
			<?php printAncestors($idBin)?>
		
		<fieldset>
			<legend>Cible</legend>
			<div>
				<label>Acuellement : </label><a target="_BLANK" href="<?=$ref->url?>"><?=$ref->url?></a>
			</div>
			<fieldset>
				<legend>Modifier</legend>
				<form id="UPDATE_RESOURCEREF_TARGET_FORM" method="POST" action="/system/service/content/update-resourceref-target.php">
					<div>
						<label>une URL externe : </label><input onfocus="document.getElementById('UPDATE_RESOURCEREF_TARGET_FORM').reset()" name="url" type="text" />
					</div>
					<div>
						<label>ou une page du site : </label><input   readonly="readonly" onclick="chooseWebPage(function(id){document.getElementById('UPDATE_RESOURCEREF_TARGET_FORM').reset();this.value=id;document.getElementById('UPDATE_RESOURCEREF_TARGET_FORM').elements['resourceId'].value=id;}.bind(this));"   type="text" pattern="[a-f0-9]{32}" />
					</div>
					<div>
						<label>ou une resource du site : </label><input  readonly="readonly" onclick="chooseResource(function(id){document.getElementById('UPDATE_RESOURCEREF_TARGET_FORM').reset();this.value=id;document.getElementById('UPDATE_RESOURCEREF_TARGET_FORM').elements['resourceId'].value=id;}.bind(this));"  type="text" pattern="[a-f0-9]{32}"  />
					</div>
					<div>
						<input type="hidden" name="resourceId" value="" />
						<input type="hidden" name="id" value="<?=bin2hex($ref->id)?>" />
						<input type="submit" value="Modifier" />
					</div>
				</form>
			</fieldset>
		</fieldset>
		<fieldset>
			<legend>Info</legend>
			<form id="UPDATE_RESOURCEREF_FORM" method="POST" action="/system/service/content/update-resourceref.php">

				<div>
					<div class="label">Commentaire</div>
					<div class="field">
						<textarea name="comment"><?=htmlentities($ref->comment)?></textarea>
					</div>
				</div>
				<div>
					<div class="label">Nom</div>
					<div class="field">
						<input name="label" type="text" value="<?=htmlentities($ref->label)?>" />
					</div>
				</div>
				<div>
					<div class="label">Description / Contenu</div>
					<div class="field">
						<textarea id="CONTENT_EDITOR" rows="5" cols="60" name="description"><?=$ref->description?></textarea>
						<script type="text/javascript">CKEDITOR.replace( 'CONTENT_EDITOR' );</script>
					</div>
				</div>
				<div>
					<div class="label">Titre (Tooltip)</div>
					<div class="field">
						<input name="title" type="text" value="<?=htmlentities($ref->title)?>" />
					</div>
				</div>
				
				<?php if($ref->img!=null){?>
				<div>
					<div class="label">&nbsp;</div>
					<div class="field">
						<img src="/system/service/content/preview-resource.php?id=<?=bin2hex($ref->img->id)?>" />
					</div>
				</div>
				<?php } ?>
				<div>
					<div class="label">Image</div>
					<div class="field">
						<input readonly="readonly" onclick="chooseImage(function(id){this.value=id}.bind(this));" pattern="[a-f0-9]{32}" name="imgId" type="text" value="<?=$ref->img==null?'':bin2hex($ref->img->id)?>" />
					</div>
				</div>
				<div>
					<div class="label">Image Alt.</div>
					<div class="field">
						<input name="imgAlt" type="text" value="<?=htmlentities($ref->imgAlt)?>" />
					</div>
				</div>
				<?php if($ref->imgOver!=null){?>
				<div>
					<div class="label">&nbsp;</div>
					<div class="field">
						<img src="/system/service/content/preview-resource.php?id=<?=bin2hex($ref->imgOver->id)?>" />
					</div>
				</div>
				<?php } ?>
				<div>
					<div class="label">Image de survol</div>
					<div class="field">
						<input readonly="readonly" onclick="chooseImage(function(id){this.value=id}.bind(this));" pattern="[a-f0-9]{32}" name="imgOverId" type="text" value="<?=$ref->imgOver==null?'':bin2hex($ref->imgOver->id)?>" />
					</div>
				</div>
				<div>
					<input type="hidden" name="id" value="<?=bin2hex($ref->id)?>" /> <input type="submit" value="Modifier" />
				</div>
			</form>
		</fieldset>
	</div>
</body>
</html>
