<?php
use xo\cms\DataList;
use xo\cms\Resource;
use xo\cms\ResourceRef;
use xo\cms\WebPage;
use xo\cms\WebSite;
use xo\content\ContentService;
use xo\content\ResourceAncestor;
use xo\cms\core\Configuration;
?>
<div class="adminModuleMenu">
	<a class="item" href="/modules/content/website">Site web</a> <a class="item" href="/modules/content/webpages">Pages Web</a> <a class="item" href="/modules/content/resources">Ressources</a> <a class="item" href="/modules/content/resourcerefs">Liens</a>
</div>
<?php
function printAncestor0(ResourceAncestor $ancestor) {
	while ( $ancestor != null && $ancestor->parent != null ) {
		if ($ancestor->parent instanceof WebPage) {
			echo '<a href="/modules/content/resource/?id=';
			echo bin2hex ( $ancestor->parent->id );
			echo '">';
			echo empty ( $ancestor->key ) ? (empty ( $ancestor->idx ) ? "" : "{$ancestor->idx}") : "{$ancestor->key} : ";
			echo 'WebPage';
			echo '</a>';
		} else if ($ancestor->parent instanceof Resource) {
			echo '<a href="/modules/content/resource/?id=';
			echo bin2hex ( $ancestor->parent->id );
			echo '">';
			echo empty ( $ancestor->key ) ? (empty ( $ancestor->idx ) ? "" : "{$ancestor->idx}") : "{$ancestor->key} : ";
			echo 'Resource';
			echo '</a>';
		} else if ($ancestor->parent instanceof DataList) {
			echo '<a href="/modules/content/list/?id=';
			echo bin2hex ( $ancestor->parent->id );
			echo '">';
			echo empty ( $ancestor->key ) ? (empty ( $ancestor->idx ) ? "" : "{$ancestor->idx}") : "{$ancestor->key} : ";
			echo 'Liste';
			echo '</a>';
		}
		
		if ($ancestor->child != null && $ancestor->child->parent) {
			echo " > ";
		}
		
		$ancestor = $ancestor->child;
	}
}
function printAncestors($valueId) {
	$service = new ContentService ( Configuration::getInstance () );
	$ancestors = $service->getAncestors ( $valueId );
	if (count ( $ancestors ) > 0) {
		echo '<fieldset>';
		echo '<legend>Références :</legend>';
		foreach ( $ancestors as $a ) {
			echo "<div>";
			printAncestor ( $a );
			echo "<div>";
		}
		echo '</fieldset>';
	}
}
function printAncestor($path) {
	for($i = 0; $i < count ( $path ); $i ++) {
		$pathElt = $path [$i];
		if ($i > 0) {
			echo ' &gt; ';
		}
		if ($pathElt instanceof WebSite) {
			echo '<span>WebSite</span>';
		} elseif ($pathElt instanceof WebPage) {
			echo '<a href="/modules/content/resource/?id=';
			echo bin2hex ( $pathElt->id );
			echo '">';
			echo 'WebPage';
			echo '</a>';
		} else if ($pathElt instanceof Resource) {
			echo '<a href="/modules/content/resource/?id=';
			echo bin2hex ( $pathElt->id );
			echo '">';
			echo 'Resource';
			echo '</a>';
		} else if ($pathElt instanceof ResourceRef) {
			echo '<a href="/modules/content/resourceref/?id=';
			echo bin2hex ( $pathElt->id );
			echo '">';
			echo 'Lien';
			echo '</a>';
		} else if ($pathElt instanceof DataList) {
			echo '<a href="/modules/content/list/?id=';
			echo bin2hex ( $pathElt->id );
			echo '">';
			echo 'Liste';
			echo '</a>';
		}
	}
}

?>
<script type="text/javascript">
function chooseResource(callback){
	var win=open("/modules/content/resources/select.php");
	var listener=function(e){
		removeEventListener("select",listener);
		callback(e.detail.message);
	};
	addEventListener("select",listener);
}
function chooseImage(callback){
	var win=open("/modules/content/resources/select.php?ct=image/jpeg");
	var listener=function(e){
		removeEventListener("select",listener);
		callback(e.detail.message);
	};
	addEventListener("select",listener);
}
function chooseWebPage(callback){
	var win=open("/modules/content/webpages/select.php");
	var listener=function(e){
		removeEventListener("select",listener);
		callback(e.detail.message);
	};
	addEventListener("select",listener);
}
function chooseResourceRef(callback){
	var win=open("/modules/content/resourcerefs/select.php");
	var listener=function(e){
		console.log(e);
		removeEventListener("select",listener);
		callback(e.detail.message);
	};
	addEventListener("select",listener);
}
</script>