<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\cms\Pagging;
use xo\cms\DataList;
use xo\cms\Resource;
use xo\cms\ResourceRef;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\ServiceRequestUtils;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Editer une ressource';
$service = new ContentService ( Configuration::getInstance () );

$httpRequest = new HttpRequest ( $_SERVER ['REQUEST_URI'] );

if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	
	$list = new DataList ( $contentService, $idBin );
	$listSize = $list->size ();
	
	$limit = 20;
	$pagging = new Pagging ( $listSize, $limit );
	if ($httpRequest->hasGetData ( "p" )) {
		$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
		if ($currentPage < 0) {
		} elseif ($currentPage > $pagging->lastPage ()) {
			header ( "Status: 301 Moved Permanently", false, 301 );
			header ( "Location: {$this->getURL()}&p={$pagging->lastPage ()}" );
			exit ();
		} else {
			$pagging->setPage ( $currentPage );
		}
	} else {
		$pagging->setPage ( 0 );
	}
	$items = $list->getItems ( false, $pagging->offset (), $limit );
} else {
	header ( "Status: 404 Not Found", false, 404 );
	exit ();
}

?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/content/list.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		
			<?php printAncestors($idBin)?>
		
		<fieldset>
			<legend>Eléments de la liste</legend>
			<div><?=$listSize?> élément(s)</div>
			<div class="table">
				<div class="thead">
					<div class="row">
						<div class="cell"></div>
						<div class="cell">Place</div>
						<div class="cell">Clé</div>
						<div class="cell">Identifiant de l'item</div>
						<div class="cell">Identifiant de la cible</div>
						<div class="cell">Type</div>
						<div class="cell">Action</div>
					</div>
				</div>
				
			<?php foreach($items as $item ){ ?>
			
			<form <?=$item->deleted?'class="row deleted"':'class="row"' ?> method="POST" action="/system/service/content/update-list-item.php">

					<div class="cell">
						<input style="display: none" type="submit" value="Modifier" />
					<?php if($item->deleted){?>
						<input class="unTrashItem btn" formaction="/system/service/content/switch-trash-list-item.php" type="submit" value="Réactiver" />
						<!-- 
						<input formaction="/system/service/content/remove-list-item.php" type="submit" value="Supprimer" />
 						-->						
						<?php }else{?>
						<input class="trashItem btn" formaction="/system/service/content/switch-trash-list-item.php" type="submit" value="Désactiver" />
						
						<?php }?>
					</div>
					<div class="cell">
						<input type="number" name="idx" value="<?=$item->idx?>" min="0" max="<?=($listSize-1)?>" />
					</div>

					<div class="cell">
						<input name="key" pattern="[a-z0-9-_]+" value="<?=htmlentities($item->key)?>" />
					</div>
					<div class="cell" style="font-size: 11px">
					<?=bin2hex($item->id)?>
						<input type="hidden" name="id" value="<?=bin2hex($item->id)?>" />
					</div>
					<div class="cell" style="font-size: 11px">
					<?=bin2hex($item->data->id)?>
						
					</div>
					<div class="cell">
					<?php if($item->data instanceof DataList){?>
					<span>Liste</span>
					<?php }?>
					<?php if($item->data instanceof Resource){?>
					<span>Resource</span>
					<?php }?>
					<?php if($item->data instanceof ResourceRef){?>
					<span>Lien</span>
					<?php }?>
					</div>
					<div class="cell">
					<?php if($item->data instanceof DataList){?>
					<a href="/modules/content/list?id=<?=bin2hex($item->data->id)?>">Éditer</a>
					<?php }?>
					<?php if($item->data instanceof Resource){?>
					<a href="/modules/content/resource?id=<?=bin2hex($item->data->id)?>">Éditer</a>
					<?php }?>
					<?php if($item->data instanceof ResourceRef){?>
					<a href="/modules/content/resourceref?id=<?=bin2hex($item->data->id)?>">Éditer</a>
					<?php }?>
					</div>

				</form>
			<?php }?>
			
			</div>
		<?php if($pagging->lastPage()>0){?>
			<div class="pagging">
		<?php if($pagging->previousPage !==null){?>
		<a href="<?=$httpRequest->getURL().'&p='.$pagging->previousPage?>">&lt;</a>
		<?php }?>
		<?php foreach($pagging->pages as $page){ ?>
		<span class="pageLinks"><a <?=$page==$pagging->page?'class="selected"':'' ?> href="<?=$httpRequest->getURL().'&p='.$page?>"><?=$page?></a></span>
		<?php }?>
		<?php if($pagging->nextPage!==null){?>
		<a href="<?=$httpRequest->getURL().'&p='.$pagging->nextPage?>">&gt;</a>
		<?php }?>
			</div>
		<?php }?>
		</fieldset>
		<fieldset>
			<legend>Ajouter un nouvel élément :</legend>
			<form id="ADD_LIST_ITEM_FORM" method="POST" action="/system/service/content/add-list-item.php">
				<fieldset>
					<legend>Du texte</legend>

					<div>
						<label>Index</label> <input type="number" name="idx" value="<?=$listSize?>" min="0" max="<?=$listSize?>" />
					</div>
					<div>
						<label>Clé</label> <input type="text" name="key" pattern="[a-z0-9-_]+" />
					</div>
					<div>
						<label>Contenu</label><br />
						<textarea name="textContent"></textarea>

					</div>

					<input type="submit" value="Ajouter du texte"> <input type="hidden" name="listId" value="<?=bin2hex($idBin)?>">

				</fieldset>
			</form>
			<form id="ADD_LIST_ITEM_FORM" method="POST" action="/system/service/content/add-list-item.php">
				<fieldset>
					<legend>Une ressource</legend>

					<div>
						<label>Index</label> <input type="number" name="idx" value="<?=$listSize?>" min="0" max="<?=$listSize?>" />
					</div>
					<div>
						<label>Clé</label> <input type="text" name="key" pattern="[a-z0-9-_]+" />
					</div>
					<div>
						<label>Identifiant de la ressource</label> <input readonly="readonly" onclick="chooseResource(function(id){this.value=id}.bind(this));" name="resourceId" type="text" pattern="[a-f0-9]{32}" />
					</div>
					<input type="submit" value="Ajouter une ressource"> <input type="hidden" name="listId" value="<?=bin2hex($idBin)?>">

				</fieldset>
			</form>
			<fieldset>
				<legend>Un lien</legend>
				<form id="ADD_LIST_ITEM_FORM" method="POST" action="/system/service/content/add-list-item.php">
					<div>
						<label>Index</label> <input type="number" name="idx" value="<?=$listSize?>" min="0" max="<?=$listSize?>" />
					</div>
					<div>
						<label>Clé</label> <input type="text" name="key" pattern="[a-z0-9-_]+" />
					</div>
					<div>
						<label>Identifiant du lien</label> <input readonly="readonly" onclick="chooseResourceRef(function(id){this.value=id}.bind(this));" name="resourceRefId" type="text" pattern="[a-f0-9]{32}" />

					</div>

					<input type="hidden" name="listId" value="<?=bin2hex($idBin)?>"> <input type="submit" value="Ajouter un lien">
				</form>
			</fieldset>
			<fieldset>
				<legend>Une liste</legend>
				<form id="ADD_LIST_ITEM_FORM" method="POST" action="/system/service/content/add-list-item.php">
					<div>
						<label>Index</label> <input type="number" name="idx" value="<?=$listSize?>" min="0" max="<?=$listSize?>" />
					</div>
					<div>
						<label>Clé</label> <input type="text" name="key" pattern="[a-z0-9-_]+" />
					</div>

					<input type="submit" value="Ajouter une liste"> <input type="hidden" name="listId" value="<?=bin2hex($idBin)?>"> <input type="hidden" name="newList" value="true">
				</form>
			</fieldset>


		</fieldset>

	</div>
</body>
</html>
