<?php 
//dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessFrenchUtils;
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;

session_start();

if(!ServiceRequestUtils::checkAuthorization('MANAGE_ACCESS')){
	exit(0);
}

$service=new AccessService(Configuration::getInstance()->db());

if(array_key_exists("id", $_GET)){
	$roleId=$_GET['id'];
}
$role=$service->getRole($roleId);
$tokens=$service->getRoleAuthorizationTokens($roleId);
$i18nUtils=new AccessFrenchUtils();


$title='Administration - Accès - Gestion des rôles';
?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/access/role.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?= $title ?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Information</legend>
			<table>
				<tr>
					<th>Id</th>
					<th>Code</th>
					<th>Libellé</th>
				</tr>
				<tr>
					<td><?= $role->getId() ?></td>
					<td><?= $role->getCode() ?></td>
					<td><?= $role->getLabel() ?></td>
				</tr>
			</table>
		</fieldset>
		<fieldset>
			<legend>Liste des authorizations :</legend>
			<table>
				<tr>
					<th>Id</th>
					<th>Code</th>
					<th>Description</th>
				</tr>
				<?php foreach($tokens as $token){ ?>
				<tr>
					<td><?= $token->getId() ?></td>
					<td><?= $token->getCode() ?></td>
					<td><?= $token->getDescription() ?></td>
				</tr>
				<?php }  ?>
			</table>
		</fieldset>
	</div>
</body>
</html>
