<?php 
//dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessFrenchUtils;
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;

session_start();


if(!ServiceRequestUtils::checkAuthorization('MANAGE_ACCESS')){
	exit(0);
}

$service=new AccessService(Configuration::getInstance()->db());
$tokens=$service->getAuthorizationTokens();
$i18nUtils=new AccessFrenchUtils();
$title='Administration - Accès - Gestion des autorisations';
?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/access/roles.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Liste des autorisations :</legend>
			<table>
				<tr>
					<th>Id</th>
					<th>Code</th>
					<th>Libellé</th>
				</tr>
				<?php foreach($tokens as $token){ ?>
				<tr>
					<td><?= $token->getId() ?></td>
					<td><?= $token->getCode() ?></td>
					<td><?= $token->getDescription() ?></td>
				</tr>
				<?php }  ?>
			</table>
		</fieldset>
	</div>
</body>
</html>
