<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessFrenchUtils;
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;

session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_ACCESS' )) {
	exit ( 0 );
}
$title = 'Administration - Accès - Gestion des accès';
$service = new AccessService ( Configuration::getInstance()->db() );
$accesses = $service->getAccesses ();
$i18nUtils = new AccessFrenchUtils ();
?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/access/accesses.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Créer un nouvel accès :</legend>
			<form id="CREATE_ACCESS" action="/system/service/access/create-access.php" method="post">
				<div>
					<input type="text" name="email" placeholder="Email" /> <input type="text" name="login" placeholder="Login" />
				</div>
				<div>
					<input type="radio" checked="checked" value="true" name="generate-password" /> <label>Générer le mot de passe</label> <br /> <input type="radio"
						value="false" name="generate-password" /> <label>Spécifier le mot de passe : </label> <input type="password" name="password1" placeholder="Mot de passe" />
					<input type="password" name="password2" placeholder="Confirmation" />
				</div>
				<div>
					<input type="submit" value="Créer" />
				</div>
			</form>
		</fieldset>
		<fieldset>
			<legend>Tester un mot de passe :</legend>
			<form id="CHECK_ACCESS" action="/system/service/access/check-access.php" method="post">
				<div>
					<input type="email" name="login" placeholder="Login" /> <input type="password" name="password" placeholder="Mot de passe" /> <input type="submit"
						value="Tester" />
				</div>
			</form>
		</fieldset>
		<fieldset>
			<legend>Accès existants :</legend>
			<table>
				<tr>
					<th>Id</th>
					<th>Login</th>
					<th>Email</th>
					<th>Statut</th>
					<th>&nbsp;</th>
				</tr>
				<?php foreach($accesses as $access){ ?>
				<tr>
					<td><?= $access->getId() ?></td>
					<td><?= $access->getLogin() ?></td>
					<td><?= $access->getEmail() ?></td>
					<td><?= $i18nUtils->getAccessStatusLabel($access->getStatus()) ?></td>
					<td><a href="/modules/access/access?id=<?=$access->getId()?>">éditer</a></td>
				</tr>
				<?php }  ?>
			</table>
		</fieldset>
	</div>
</body>
</html>
