<?php use xo\cms\Pagging;?>
<?php use xo\www\HttpRequest;?>
<?php 
$products = $ctx->data ( "products" );
$limit = 5;
$count = $products->size ( false );
$pagging = new Pagging ( $count, $limit );
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "p" )) {
	$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
	if ($currentPage < 0) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p=0" );
	} elseif ($currentPage > $pagging->lastPage ()) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p={$pagging->lastPage ()}" );
		exit ();
	} else {
		$pagging->setPage ( $currentPage );
	}
} else {
	$pagging->setPage ( 0 );
}
?>
<div class="main store">
	<div class="titles">
	
	<?=$ctx->dataAsHtml("titles")?>
	</div>
	<hr />
	<div class="intro"><?=$ctx->dataAsHtml("intro")?></div>
	<div class="tabs-parent">
	<div class="tabs">
	<?=$ctx->dataAsHtml( "tabs" )?>	
	</div>
	</div>
	<div class="listing" data-list-id="<?=bin2hex($products->id)?>">
	<?php
	foreach ( $products->getItems ( true, $pagging->offset (), $limit, false ) as $item ) {
		$product = $item->data;
		
	?>
		<div class="item " data-ref-id="<?=bin2hex($product->id)?>">
		<?=$ctx->html($product)?>
		</div>
	<?php 
	}	
	?>
	
	</div>
</div>

<?php include 'pagging.tpl.php'?>
