<?php use xo\cms\Pagging;?>
<?php use xo\www\HttpRequest;?>
<div class="main secretaries">
	<div class="titles">
	<?=$ctx->dataAsHtml("titles")?>
	</div>
	<div class="tabs">
	<?=$ctx->dataAsHtml( "tabs" )?>	
	</div>
	<div class="intro"><?=$ctx->dataAsHtml("intro")?></div>
	<?php
	
	$secretaries = $ctx->data ( "secretaries" );
	$limit = 5;
	$count = $ctx->data ( "secretaries" )->size ( false );
	$pagging = new Pagging ( $count, $limit );
	$httpRequest = new HttpRequest ();
	if ($httpRequest->hasGetData ( "p" )) {
		$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
		if ($currentPage < 0) {
			header ( "Status: 301 Moved Permanently", false, 301 );
			header ( "Location: ?p=0" );
		} elseif ($currentPage > $pagging->lastPage ()) {
			header ( "Status: 301 Moved Permanently", false, 301 );
			header ( "Location: ?p={$pagging->lastPage ()}" );
			exit ();
		} else {
			$pagging->setPage ( $currentPage );
		}
	} else {
		$pagging->setPage ( 0 );
	}
	?>
	<div class="listing" data-list-id="<?=bin2hex($secretaries->id)?>">
	<?php
	
	foreach ( $secretaries->getItems ( true, $pagging->offset (), $limit, false ) as $item ) {
		$partner = $item->data;
		?>
		<div class="item " data-ref-id="<?=bin2hex($partner->id)?>">
			<div class="r1">
				<div class="c1">
					<div class="img">
						<a href="<?=htmlentities($partner->url)?>">
							<img class="under" src="<?=htmlentities($partner->img->path->path)?>" />
							
						</a>
					</div>

				</div>
				<div class="c2">
					<div class="title"><?=htmlentities($partner->label)?></div>
					<div class="description"><?=$partner->description?></div>

				</div>
			</div>

			<div class="r2">
				<a href="<?=htmlentities($partner->url)?>" class="link">En savoir plus</a>
			</div>
		</div>
		
		
		<?php }?>
	</div>
</div>
<?php

include 'pagging.tpl.php'?>
