<?php

namespace xo\www;

use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;

class ServiceRequestUtils {
	private static $LOGIN_REDIRECT_URL_COOKIE_KEY = 'LOGIN_REDIRECT';
	private static $CAPTCHA_SESSION_KEY = 'CAPTCHA';
	private static $CAPTCHA_LENGTH = 6;
	public static function createDTO($fields, $data = null) {
		if ($data === null) {
			$data = $_POST;
		}
		$dto = array ();
		$httpRequest = new HttpRequest ();
		foreach ( $fields as $key ) {
			$dto [$key] = $httpRequest->getPostData ( $key );
		}
		return $dto;
	}
	public static function setRequestResult($requestCode, JavaScriptRequestResultWrapper $wrapper, $redirection = null) {
		setrawcookie ( $requestCode . '_REQUEST_RESULT', rawurlencode ( json_encode ( $wrapper ) ), time () + 60, "/" );
		if (empty ( $redirection )) {
			$redirection = $_SERVER ['HTTP_REFERER'];
			if (empty ( $redirection ))
				$redirection = '/';
		}
		self::generateCaptcha ();
		self::sendSeeOtherRedirectHeader ( $redirection );
	}
	public static function checkAuthorization($token, $sendRedirectHeader = true) {
		$config = Configuration::getInstance ();
		$accessService = new AccessService ( $config->db () );
		$accessId = $accessService->getCurrentAccessId ();
		// error_log("checkAuthorization $accessId $token");
		if ($accessId != null) {
			if ($accessService->hasAuthorization ( $accessId, $token )) {
				if ($sendRedirectHeader) {
					if (isset ( $_SERVER ['REDIRECT_URL'] )) {
						$uri = $_SERVER ['REDIRECT_URL'];
					} else {
						$uri = $_SERVER ['REQUEST_URI'];
					}
					$loginRedirect = self::getLoginRedirectCookie ();
					if ($loginRedirect == $uri) {
						self::removeLoginRedirectCookie ();
					}
				}
				return true;
			}
		}
		if ($sendRedirectHeader) {
			self::sendRedirect403Header ();
		}
		return false;
	}
	public static function sendRedirect403Header() {
		if (isset ( $_SERVER ['REDIRECT_URL'] )) {
			$uri = $_SERVER ['REDIRECT_URL'];
		} else {
			$uri = $_SERVER ['REQUEST_URI'];
		}
		header ( "HTTP/1.1 403" );
		header ( "Location: /erreur/403" );
		self::setLoginRedirectCookie ( $uri );
	}
	
	// LOGIN REDIRECTION :
	public static function getLoginRedirectCookie() {
		$url = null;
		if (array_key_exists ( self::$LOGIN_REDIRECT_URL_COOKIE_KEY, $_COOKIE )) {
			$url = $_COOKIE [self::$LOGIN_REDIRECT_URL_COOKIE_KEY];
		}
		return $url;
	}
	public static function removeLoginRedirectCookie() {
		setrawcookie ( self::$LOGIN_REDIRECT_URL_COOKIE_KEY, '', time () - 3600, "/" );
	}
	public static function setLoginRedirectCookie($url) {
		setrawcookie ( self::$LOGIN_REDIRECT_URL_COOKIE_KEY, rawurlencode ( $url ), time () + 3600, "/" );
	}
	
	// NOT FOUND REDIRECTION
	public static function sendPageNotFoundRedirectHeader($url) {
		header ( "HTTP/1.0 404 Not Found" );
		header ( "Location: /erreur/404?url=" . urlencode ( $url ) );
		echo '<html><head><meta http-equiv="Refresh" content="0;URL=/erreur/404?url=' . $url . '" /></head><body></body></html>';
	}
	public static function getPageNotFoundUrl() {
		$request = new HttpRequest ();
		return $request->getGetDataAsText ( "url" );
	}
	
	// Moved Permanently Redirection
	public static function sendMovedPermanentlyRedirectHeader($url) {
		header ( "HTTP/1.0 301 Moved Permanently" );
		header ( "Location: $url" );
	}
	
	// See Other Redirection
	public static function sendSeeOtherRedirectHeader($url) {
		header ( "HTTP/1.0 303 See Other" );
		header ( "Location: $url" );
	}
	
	// Captcha
	public static function checkCaptcha($code, $generateNewOne = true) {
		$captcha = null;
		if (key_exists ( self::$CAPTCHA_SESSION_KEY, $_SESSION )) {
			$captcha = $_SESSION [self::$CAPTCHA_SESSION_KEY];
		}
		$result = $code == $captcha;
		if ($generateNewOne)
			self::generateCaptcha ();
		return $result;
	}
	public static function getCaptcha() {
		$captcha = null;
		if (key_exists ( self::$CAPTCHA_SESSION_KEY, $_SESSION )) {
			$captcha = $_SESSION [self::$CAPTCHA_SESSION_KEY];
		}
		if (empty ( $captcha )) {
			$captcha = self::generateCaptcha ();
		}
		return $captcha;
	}
	public static function generateRandomCharSequence($length, $chars = 'abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789') {
		$maxIdx = strlen ( $chars ) - 1;
		$text = '';
		for($i = 0; $i < $length; $i ++) {
			$idx = rand ( 0, $maxIdx );
			$text .= $chars [$idx];
		}
		return $text;
	}
	public static function generateCaptcha() {
		$captcha = self::generateRandomCharSequence ( self::$CAPTCHA_LENGTH );
		$_SESSION [self::$CAPTCHA_SESSION_KEY] = $captcha;
		return $captcha;
	}
}

?>