<?php

namespace xo\www;

class HttpRequest {
	private $url;
	private $method;
	public static $POST_METHOD = "POST";
	public static $GET_METHOD = "GET";
	public function __construct($url = null) {
		$this->url = $url;
		$this->method = $_SERVER ["REQUEST_METHOD"];
	}
	public function getMethod() {
		return $this->method;
	}
	public function getURL() {
		return $this->url;
	}
	public static function safeHTML($html) {
		$config = HTMLPurifier_Config::createDefault ();
		$config->set ( 'Attr.EnableID', true );
		$config->set ( 'HTML.Trusted', true );
		$htmlVerifier = new HTMLPurifier ( $config );
		return $html; // $htmlVerifier->purify($html);
	}
	public static function noHtml($text) {
		return htmlspecialchars ( $text, ENT_COMPAT, 'UTF-8' );
	}
	
	// POST
	public function hasPost() {
		return count ( $_POST ) > 0;
	}
	public function hasPostKey($key) {
		return isset ( $_POST [$key] );
	}
	public function hasPostData($key) {
		return $this->hasPostKey ( $key ) && ! empty ( $_POST [$key] );
	}
	public function getPostDataAsHTML($key) {
		//$dataAsHTML = self::safeHTML ( $this->getPostData ( $key ) );
		//$dataAsHTML = stripslashes ( $dataAsHTML );
		//return $dataAsHTML;
		//FIXME
		return  $this->getPostData ( $key );
	}
	public function getPostDataAsText($key) {
		//$dataAsText = htmlspecialchars ( $this->getPostData ( $key ), ENT_COMPAT, 'UTF-8' );
		
		//return $dataAsText;
		return  $this->getPostData ( $key );
	}
	public function getPostData($key) {
		$data = null;
		if (array_key_exists ( $key, $_POST )) {
			if (get_magic_quotes_gpc ()) {
				if (is_array ( $_POST [$key] )) {
					$data = array ();
					foreach ( $_POST [$key] as $d ) {
						array_push ( $data, stripslashes ( $d ) );
					}
				} else {
					$data = stripslashes ( $_POST [$key] );
				}
			} else {
				$data = $_POST [$key];
			}
		}
		return $data;
	}
	public function getPostDataAsInteger($key) {
		return 0 + $this->getPostData ( $key );
	}
	public function getPostDataAsArrayOfIntegers($key) {
		$integers = array ();
		$data = $this->getPostData ( $key );
		if (is_array ( $data )) {
			foreach ( $data as $d ) {
				array_push ( $integers, 0 + $d );
			}
		} else {
			array_push ( $integers, 0 + $data );
		}
		return $integers;
	}
	
	// GET
	public function hasGetKey($key) {
		return isset ( $_GET [$key] );
	}
	public function hasGetData($key) {
		return $this->hasGetKey ( $key ) && ! empty ( $_GET [$key] );
	}
	public function getGetData($key) {
		if (get_magic_quotes_gpc ()) {
			$data = stripslashes ( $_GET [$key] );
		} else {
			$data = $_GET [$key];
		}
		
		return $data;
	}
	public function getGetDataAsText($key) {
		return htmlspecialchars ( $this->getGetData ( $key ), ENT_COMPAT, 'UTF-8' );
	}
	public function getGetDataAsInteger($key) {
		return ( int ) $this->getGetData ( $key );
	}
}

?>