<?php

namespace xo\message;

class MessageService {
	private $db;
	public function __construct($db) {
		$this->db = $db;
	}
	public function getMessageAttachment($id) {
		$query = "select * from MESSAGE_ATTACHMENT where data_id=?";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$id 
		) );
		$row = $stmt->fetch ();
		if ($row) {
			return new MessageAttachment ( $row ['MESSAGE_ID'], $row ['DATA_ID'], $row ['NAME'], $row ['FILE_NAME'], $row ['CONTENT_TYPE'] );
		}
		return null;
	}
	public function getMessageById($id) {
		$query = "select * from MESSAGE where id=?";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$id 
		) );
		$row = $stmt->fetch ();
		
		if ($row) {
			$message = new Message ( $row ['ID'], $row ['TYPE'], $row ['DATE'], $row ['EMAIL'], $row ['TITLE'], $row ['CONTENT'] );
			$query = "select * from MESSAGE_ATTACHMENT where MESSAGE_ID = ? order by place asc;";
			$stmt = $this->db->prepare ( $query );
			$stmt->execute ( array (
					$id 
			) );
			$rows = $stmt->fetchAll ();
			foreach ( $rows as $row ) {
				$message->addAttachment ( new MessageAttachment ( $row ['MESSAGE_ID'], $row ['DATA_ID'], $row ['NAME'], $row ['FILE_NAME'], $row ['CONTENT_TYPE'] ) );
			}
			return $message;
		}
		
		return null;
	}
	public function getAttachmentPath($attachment) {
		$name = $attachment->dataId;
		$prefix = substr ( $name, 0, 2 );
		return "attachment/$prefix/$name";
	}
	public function getMessagesByTypeCode($typeCode) {
		$query = "select ID,TYPE,DATE,EMAIL,TITLE from MESSAGE where type = ? order by date desc;";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$typeCode 
		) );
		$rows = $stmt->fetchAll ();
		$messages = array ();
		foreach ( $rows as $row ) {
			$message = new Message ( $row ['ID'], $row ['TYPE'], $row ['DATE'], $row ['EMAIL'], $row ['TITLE'] );
			array_push ( $messages, $message );
		}
		return $messages;
	}
	public function getMessageTypeByCode($code, $lang = 'FR') {
		$query = "select * from MESSAGE_TYPE_I18N where CODE =? and  LANG=?;";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$code,
				$lang 
		) );
		$row = $stmt->fetch ();
		
		if ($row) {
			return new MessageType ( $row ['LANG'], $row ['CODE'], $row ['LABEL'] );
		}
		return null;
	}
	public function getMessageTypes($lang = 'FR') {
		$query = "select * from MESSAGE_TYPE_I18N where LANG=?;";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$lang 
		) );
		$rows = $stmt->fetchAll ();
		$types = array ();
		foreach ( $rows as $row ) {
			$type = new MessageType ( $row ['LANG'], $row ['CODE'], $row ['LABEL'] );
			array_push ( $types, $type );
		}
		return $types;
	}
	private function purifyString($text) {
		$path = strtolower ( trim ( $text ) );
		$path = str_replace ( array (
				'à',
				'á',
				'â',
				'ã',
				'å' 
		), 'a', $path );
		$path = str_replace ( array (
				'è',
				'é',
				'ê',
				'ë' 
		), 'e', $path );
		$path = str_replace ( array (
				'ì',
				'í',
				'î',
				'ï' 
		), 'i', $path );
		$path = str_replace ( array (
				'ò',
				'ó',
				'ô',
				'õ',
				'ø' 
		), 'o', $path );
		$path = str_replace ( array (
				'ù',
				'ú',
				'û' 
		), 'u', $path );
		$path = str_replace ( array (
				'æ',
				'œ',
				'ý',
				'ÿ',
				'ç',
				'ß',
				'ñ' 
		), array (
				'ae',
				'oe',
				'y',
				'y',
				'c',
				'ss',
				'n' 
		), $path );
		$path = str_replace ( array (
				'ä',
				'ö',
				'ü' 
		), array (
				'a',
				'o',
				'u' 
		), $path );
		$path = preg_replace ( '/[^0-9a-z]/', ' ', $path );
		$path = trim ( $path );
		$path = preg_replace ( '/[ -]+/', '-', trim ( $path ) );
		return $path;
	}
	private function getFileExtension($contentType) {
		switch ($contentType) {
			case "application/pdf" :
				return ".pdf";
			case "application/vnd.openxmlformats-officedocument.wordprocessingml.document" :
				return ".docx";
			case "application/msword" :
				return ".doc";
		}
		return "";
	}
	public function createMessage($typeCode, $email, $title, $content, $attachments = array()) {
		$query = "insert into MESSAGE(TYPE,EMAIL,TITLE,CONTENT) values(?,?,?,?) ";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$typeCode,
				$email,
				$title,
				$content 
		) );
		$msgId = $this->db->lastInsertId ();
		if ($msgId > 0) {
			$place = 0;
			foreach ( $attachments as $attachment ) {
				$place ++;
				$query = "insert into MESSAGE_ATTACHMENT(MESSAGE_ID,PLACE,DATA_ID,NAME,FILE_NAME,CONTENT_TYPE) values(?,?,?,?,?,?) ";
				$stmt = $this->db->prepare ( $query );
				$fileName = self::purifyString ( "$attachment->name $title" );
				$fileName .= self::getFileExtension ( $attachment->contentType );
				$stmt->execute ( array (
						$msgId,
						$place,
						$attachment->dataId,
						$attachment->name,
						$fileName,
						$attachment->contentType 
				) );
			}
		} else {
			throw new ServiceFunctionalException ( "Error DB" );
		}
	}
	private function send($sending) {
		$mailer = new \PHPMailer();
		$mailer->CharSet = "UTF-8";
		$mailer->isHTML ();
		$mailer->setFrom ( $sending->config->from, $sending->config->sender );
		$message = $sending->message;
		$mailer->addAddress ( $message->email );
		$ccs = explode  ( "\n", $sending->config->cc );
		foreach ( $ccs as $cc ) {
			if (! empty ( $cc )) {
				$mailer->addCC ( $cc );
			}
		}
		$bccs = explode ( "\n", $sending->config->bcc );
		foreach ( $bccs as $bcc ) {
			if (! empty ( $bcc )) {
				$mailer->addBCC ( $bcc );
			}
		}
		$mailer->Subject = $sending->config->subject;
		
		$mailer->Body = $message->content;
		foreach ( $message->getAttachments () as $attachment ) {
			$file = DATA_PATH . $this->getAttachmentPath ( $attachment );
			$mailer->addAttachment ( $file, $attachment->fileName );
		}
		if ($mailer->send ()) {
			$query = "update MESSAGE set SENDING_DATE = NOW() where id = ?";
			$stmt = $this->db->prepare ( $query );
			$stmt->execute ( array (
					$message->id 
			) );
		} else {
			echo "Mailer Error: " . $mailer->ErrorInfo;
		}
	}
	public function sendMessages() {
		$sendings = array ();
		try {
			$query = "SELECT m.ID,c.SENDER_EMAIL,c.SENDER_NAME,c.CC,c.BCC,c.SUBJECT FROM  MESSAGE m join MESSAGE_SERVICE_CONFIG c on m.type=c.type where m.SENDING_DATE is null";
			$stmt = $this->db->prepare ( $query );
			$stmt->execute ();
			$rows = $stmt->fetchAll ();
			foreach ( $rows as $row ) {
				$config = new MessageServiceConfiguration ( null, null, $row ['SENDER_EMAIL'], $row ['SENDER_NAME'], $row ['CC'], $row ['BCC'], $row ['SUBJECT'] );
				$message = $this->getMessageById ( $row ['ID'] );
				$sending = new MessageSending ( $config, $message );
				array_push ( $sendings, $sending );
			}
			foreach ( $sendings as $sending ) {
				$this->send ( $sending );
			}
		} catch ( Exception $e ) {
			var_dump ( $e );
		}
	}
	public function getConfigurations($lang = 'FR') {
		$configurations = array ();
		$query = "SELECT  c.*,t.label as TYPE_LABEL FROM MESSAGE_SERVICE_CONFIG c join MESSAGE_TYPE_I18N t on c.TYPE=t.CODE where lang=?";
		$stmt = $this->db->prepare ( $query );
		$stmt->execute ( array (
				$lang 
		) );
		$rows = $stmt->fetchAll ();
		foreach ( $rows as $row ) {
			$type = new MessageType ( $lang, $row ['TYPE'], $row ['TYPE_LABEL'] );
			$config = new MessageServiceConfiguration ( $row ['ID'], $type, $row ['SENDER_EMAIL'], $row ['SENDER_NAME'], $row ['CC'], $row ['BCC'], $row ['SUBJECT'] );
			array_push ( $configurations, $config );
		}
		return $configurations;
	}
	public function updateConfiguration($id, $from, $sender, $subject, $cc, $bcc) {
		try {
			$configurations = array ();
			$query = "UPDATE MESSAGE_SERVICE_CONFIG set SENDER_EMAIL=?,SENDER_NAME=?,SUBJECT=?,CC=?,BCC=? where id=?";
			$stmt = $this->db->prepare ( $query );
			$stmt->execute ( array (
					$from,
					$sender,
					$subject,
					$cc,
					$bcc,
					$id 
			) );
		} catch ( Exception $e ) {
			error_log ( $e );
		}
	}
}
?>