<?php

namespace xo\cms;


use xo\cms\core\Configuration;
use xo\content\ContentService;
class WebPageTemplateContext {
	public $webPage;
	private $service;
	function __construct(WebPage $webPage) {
		$this->webPage = $webPage;
		$this->service=new ContentService(Configuration::getInstance());
	}
	function data($key) {
		$item = $this->webPage->model->get ( $key );
		return empty ( $item ) ? null : $item->data;
	}
	function dataAsHtml($key,$classnames=null) {
		
		return $this->html ( $this->data ( $key ),$classnames );
	}
	function html($data,$classnames=null) {
	
		if ($data instanceof DataList) {
			$html = '<div class="items" >';
			$html .= "\n";
			foreach ( $data->getItems (true,0,500,false) as $item ) {
				$html .= '<div class="item" ';
				if (! empty ( $item->idx )) {
					$html .= ' data-list-idx="';
					$html .= htmlentities ( $item->idx );
					$html .= '"';
				}
				if (! empty ( $item->key )) {
					$html .= ' data-list-key="';
					$html .= htmlentities ( $item->key );
					$html .= '"';
				}
				$html .= ">\n";
				$html .= $this->html ( $item->data );
				$html .= "</div>\n";
			}
			$html .= '</div>';
			return $html;
		}
		if ($data instanceof ResourceRef) {
			return $this->resourceRefToAnchor ( $data );
		}
		if ($data instanceof Resource ) {
			return '<div '.($classnames==null?'':"class=$classnames").'data-res-id="'.bin2hex($data->id).'" >'.$this->service->getResourceData($data->data).'</div>';
			
		}
		return "";
	}
	function resourceRefToAnchor($resourceRef) {
		$html = '<a';
		$html .= ' data-ref-id="';
		$html .= bin2hex($resourceRef->id) ;
		$html .= '"';
		$html .= ' href="';
		$html .= htmlentities ( $resourceRef->url );
		$html .= '"';
		if (! empty ( $resourceRef->title )) {
			$html .= ' title="';
			$html .= htmlentities ( $resourceRef->title );
			$html .= '"';
		}
		if (! empty ( $resourceRef->code )) {
			$html .= ' data-link-code="';
			$html .= htmlentities ( $resourceRef->code );
			$html .= '"';
		}
		$html .= '>';
		if (! empty ( $resourceRef->img )) {
			
			
			$html .= '<img ';
			if (! empty ( $resourceRef->imgOver )) {
				$html .='class="under" ';
			}
			
			$html .= 'src="';
			$html .= $resourceRef->img->path->path;  
			$html .= '"';
			if (! empty ( $resourceRef->imgAlt )) {
				$html .= ' alt="';
				$html .= htmlentities ( $resourceRef->imgAlt );
				$html .= '"';
			}
// 			if (! empty ( $resourceRef->imgOver )) {
// 				$html .= ' data-src-over="';
// 				$html .= htmlentities ( $resourceRef->imgOver->path->path );
// 				$html .= '"';
// 			}
			$html .= '/>';
			
			
			if (! empty ( $resourceRef->imgOver )) {	
				$html .= '<img class="over" src="';
				$html .= $resourceRef->imgOver->path->path;
				$html .= '"';
				if (! empty ( $resourceRef->imgAlt )) {
					$html .= ' alt="';
					$html .= htmlentities ( $resourceRef->imgAlt );
					$html .= '"';
				}
				$html .= '/>';
			}
		}
		if (! empty ( $resourceRef->label )) {
			$html .= '<span class="label" >';
			$html .= htmlentities ( $resourceRef->label );
			$html .= '</span>';
		}
		$html .= '</a>';
		$html .= "\n";
		return $html;
	}
}
?>
