<?php

namespace xo\cms;

class Pagging {
	public $page;
	public $pages;
	public $previousPage;
	public $nextPage;
	public $itemsPerPage;
	function __construct($itemsCount, $itemPerPage, $pageLinksCount=9) {
		$this->itemsCount = intval ( $itemsCount );
		$this->itemsPerPage = intval ( $itemPerPage );
		$this->pageLinksCount = intval ( $pageLinksCount );
	}
	public function offset() {
		return $this->itemsPerPage * $this->page;
	}
	public function lastPage() {
		return $this->pageCount() - 1;
	}
	public function pageCount() {
		$pageCount = intval ( $this->itemsCount / $this->itemsPerPage ) + 1;
		if ($this->itemsCount % $this->itemsPerPage == 0) {
			$pageCount --;
		}
		return $pageCount;
	}
	public function setPage($currentPage) {
		$pageCount = $this->pageCount ();
		$lastPage = $this->lastPage ();
		
		$this->page = $currentPage;
		
		$firstLink = $this->page;
		
		if ($firstLink + $this->pageLinksCount > $pageCount) {
			$firstLink = $pageCount - $this->pageLinksCount;
		}
		if ($firstLink < 0) {
			$firstLink = 0;
		}
		$lastLink = $firstLink + $this->pageLinksCount;
		if ($lastLink > $lastPage) {
			$lastLink = $lastPage;
		}
		
		$this->pages = array ();
		for($i = $firstLink; $i <= $lastLink; $i ++) {
			array_push ( $this->pages, $i );
		}
		
		$this->previousPage = $this->page > 0 ? $this->page - 1 : null;
		$this->nextPage = $this->page < $lastPage ? $this->page + 1 : null;
	}
}
?>