<?php

namespace xo\cms;

class DataManagerMock implements IDataManager {
	function getList($listId) {
		return new DataList ( $this, $listId );
	}
	private function common(&$items) {
		$item = new DatalistItem ();
		$item->key = "menu-left";
		$item->data = $this->getList ( "menu-left" );
		array_push ( $items, $item );
		
		$item = new DatalistItem ();
		$item->key = "logos";
		$item->data = $this->getList ( "logos" );
		array_push ( $items, $item );
		
		$item = new DatalistItem ();
		$item->key = "header-links";
		$item->data = $this->getList ( "header-links" );
		array_push ( $items, $item );
		
		$item = new DatalistItem ();
		$item->key = "menu-footer";
		$item->data = $this->getList ( "menu-footer" );
		array_push ( $items, $item );
		
		$item = new DatalistItem ();
		$item->key = "menu-rubriques";
		$item->data = $this->getList ( "menu-rubriques" );
		array_push ( $items, $item );
	}
	public function getListItems($listId) {
		$items = array ();
		switch ($listId) {
			case "menu-footer" :
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->url = "/credits-mentions-legales";
				$item->data->label = "Crédits et Mentions Légales";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 2;
				$item->data = new ResourceRef ();
				$item->data->url = "/conditions-d-utilisation";
				$item->data->label = "Conditions d’utilisation";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 3;
				$item->data = new ResourceRef ();
				$item->data->url = "/contact";
				$item->data->label = "Contact";
				array_push ( $items, $item );
				break;
			case "menu-rubriques" :
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->url = "/qui-sommes-nous";
				$item->data->label = "Qui sommes nous";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 2;
				$item->data = new ResourceRef ();
				$item->data->url = "/partenaires";
				$item->data->label = "Nos partenaires";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 3;
				$item->data = new ResourceRef ();
				$item->data->url = "/adherez";
				$item->data->label = "Demande d'adhésion";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 4;
				$item->data = new ResourceRef ();
				$item->data->url = "/#1:0:0:";
				$item->data->label = "Actualités";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 5;
				$item->data = new ResourceRef ();
				$item->data->url = "/#2:0:0:";
				$item->data->label = "Communiqués";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 6;
				$item->data = new ResourceRef ();
				$item->data->url = "/#3:0:0:";
				$item->data->label = "Publication";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 7;
				$item->data = new ResourceRef ();
				$item->data->url = "/#4:0:0:";
				$item->data->label = "Multimedia";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 8;
				$item->data = new ResourceRef ();
				$item->data->url = "/instances";
				$item->data->label = "Instances";
				array_push ( $items, $item );
				break;
			case "header-links" :
				$item = new DatalistItem ();
				$item->key = "home";
				$item->data = new ResourceRef ();
				$item->data->url = "/";
				$item->data->img = new Resource ( null );
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/logo-fo-fec.png";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "contact-us";
				$item->data = new ResourceRef ();
				$item->data->url = "/contact";
				$item->data->label = "Contactez-nous";
				array_push ( $items, $item );
				break;
			case "partners" :
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 7;
				$item->data->url = "/partenaires/adeis";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/partenaires/Adeis-nb.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/partenaires/Adeis.png";
				$item->data->imgAlt = "Adeis";
				$item->data->label = "Adeis";
				$item->data->description = "Mauris vel augue efficitur, gravida elit in, egestas leo. Mauris elementum commodo laoreet. Donec porta ligula sed tellus ultrices, sed laoreet diam blandit. Mauris elit augue, accumsan at ante ultrices, cursus porta dolor. Vivamus pretium.";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 8;
				$item->data->url = "/partenaires/ag2r-la-mondiale";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/partenaires/Ag2r-nb.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/partenaires/Ag2r.png";
				$item->data->imgAlt = "Ag2r La Mondiale";
				$item->data->label = "Ag2r La Mondiale";
				$item->data->description = "Pellentesque lacinia nisi vitae tempor ultrices. Morbi leo mi, convallis vel felis vel, vulputate egestas massa. Aenean in tellus at felis pellentesque imperdiet. Proin ligula mi, tempor ornare turpis et, ultrices molestie purus. Proin a.";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 9;
				$item->data->url = "/partenaires/diagoris";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/partenaires/Diagoris-nb.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/partenaires/Diagoris.png";
				$item->data->imgAlt = "Diagoris";
				$item->data->label = "Diagoris";
				$item->data->description = "Maecenas eu ex ut nisi condimentum dignissim. Sed finibus nulla nunc, id dignissim eros lobortis sed. Nullam hendrerit elementum pellentesque. Sed augue arcu, elementum tempus mi et, sollicitudin ullamcorper sem. Donec efficitur malesuada dignissim. Phasellus.";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 10;
				$item->data->url = "/partenaires/humanis";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/partenaires/Humanis-nb.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/partenaires/Humanis.png";
				$item->data->imgAlt = "Humanis";
				$item->data->label = "Humanis";
				$item->data->description = "Suspendisse viverra vitae nibh in hendrerit. Pellentesque ut tincidunt erat. Nulla in libero ac nunc sollicitudin egestas quis vel felis. Integer sit amet neque eget massa gravida dapibus. Quisque vel tristique magna. Aenean at venenatis.";
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 11;
				$item->data->url = "/partenaires/incp";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/partenaires/Incp-nb.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/partenaires/Incp.png";
				$item->data->imgAlt = "Incp";
				$item->data->label = "Incp";
				$item->data->description = "In lacus ipsum, cursus eget sagittis sit amet, aliquet interdum libero. Nullam vel dolor elit. Suspendisse volutpat neque vel consectetur ultricies. Suspendisse potenti. Sed vel libero at lectus semper venenatis. Maecenas ultricies tincidunt neque, et.";
				array_push ( $items, $item );
				break;
			case "logos" :
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 6;
				$item->data->url = "http://www.force-ouvriere.fr/";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/logos/logos-reseau-fo-conf.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/logos/logos-reseau-fo-conf-on.png";
				$item->data->imgAlt = "FO Conf.";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 2;
				$item->data = new ResourceRef ();
				$item->data->id = 7;
				$item->data->url = "http://www.fo-cadres.fr/";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/logos/logos-reseau-fo-cadres.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/logos/logos-reseau-fo-cadres-on.png";
				$item->data->imgAlt = "FO Cadres";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 3;
				$item->data = new ResourceRef ();
				$item->data->id = 8;
				$item->data->url = "http://www.uniglobalunion.org/fr";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/logos/logos-reseau-fo-uni.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/logos/logos-reseau-fo-uni-on.png";
				$item->data->imgAlt = "FO UNI";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 4;
				$item->data = new ResourceRef ();
				$item->data->id = 9;
				$item->data->url = "http://www.afoc.net/";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/img/logos/logos-reseau-fo-afoc.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/img/logos/logos-reseau-fo-afoc-on.png";
				$item->data->imgAlt = "FO AFOC";
				array_push ( $items, $item );
				break;
			case "menu-left" :
				$item = new DatalistItem ();
				$item->idx = 2;
				$item->data = new ResourceRef ();
				$item->data->id = 3;
				$item->data->url = "/qui-sommes-nous";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/rubrique-qui-sommes-nous.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/css/img/rubrique-qui-sommes-nous-on.png";
				$item->data->imgAlt = "Qui sommes nous?";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 4;
				$item->data->url = "/partenaires";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/rubrique-nos-partenaires.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/css/img/rubrique-nos-partenaires-on.png";
				$item->data->imgAlt = "Partenaires";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->id = 5;
				$item->data->url = "/adherez";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/rubrique-adherez.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/css/img/rubrique-adherez-on.png";
				$item->data->imgAlt = "Nous rejoindre";
				array_push ( $items, $item );
				break;
			case "about-us-tab" :
				$item = new DatalistItem ();
				$item->idx = 1;
				$item->data = new ResourceRef ();
				$item->data->url = "/qui-sommes-nous/la-federation";
				$item->data->id = 20;
				$item->data->code = "about-us";
				$item->data->label = "La fédération";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 2;
				$item->data = new ResourceRef ();
				$item->data->url = "/qui-sommes-nous/histoire-de-la-fec";
				$item->data->id = 21;
				$item->data->label = "Histoire de la FEC";
				$item->data->code = "history";
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->idx = 3;
				$item->data = new ResourceRef ();
				$item->data->url = "/qui-sommes-nous/secretaires-generaux";
				$item->data->id = 22;
				$item->data->label = "Secrétaires généraux";
				$item->data->code = "secretaries";
				array_push ( $items, $item );
				
				break;
			case "/contact" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Contact</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Contact --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case '/adherez' :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Adhérez</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Adhésion --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case "/credits" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Crédits</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Crédits --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case "/mentions-legales" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Mentions légales</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Mentions légales --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case "/qui-sommes-nous/la-federation" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Qui sommes nous?</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">La fédération --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "downloadLink";
				$item->data = new ResourceRef ();
				$item->data->url = "http://ged.fecfo.fr/download/";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/picto-PDF.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/css/img/picto-PDF-on.png";
				$item->data->id = 18;
				$item = new DatalistItem ();
				$item->key = "tabs";
				$item->data = $this->getList ( "about-us-tab" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case "/qui-sommes-nous/histoire-de-la-fec" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Qui sommes nous?</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Histoire de la FEC --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "downloadLink";
				$item->data = new ResourceRef ();
				$item->data->url = "http://ged.fecfo.fr/download/";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/picto-PDF.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/css/img/picto-PDF-on.png";
				$item->data->id = 18;
				$item = new DatalistItem ();
				$item->key = "tabs";
				$item->data = $this->getList ( "about-us-tab" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case "/qui-sommes-nous/secretaires-generaux" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Qui sommes nous?</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Secrétaires généraux  --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "downloadLink";
				$item->data = new ResourceRef ();
				$item->data->url = "http://ged.fecfo.fr/download/";
				$item->data->img = new Resource ( null );
				$item->data->img->path = "/css/img/picto-PDF.png";
				$item->data->imgOver = new Resource ( null );
				$item->data->imgOver->path = "/css/img/picto-PDF-on.png";
				$item->data->id = 18;
				$item = new DatalistItem ();
				$item->key = "tabs";
				$item->data = $this->getList ( "about-us-tab" );
				array_push ( $items, $item );
				$item = new DatalistItem ();
				$item->key = "content";
				$item->data = new SimpleData ( 3, "" );
				array_push ( $items, $item );
				$this->common ( $items );
				break;
			case "/partenaires" :
				$item = new DatalistItem ();
				$item->key = "titles";
				$item->data = new SimpleData ( 1, "<h1>Nos partenaires</h1><h2>Fédération employés &amp; cadres</h2>" );
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->key = "intro";
				$item->data = new SimpleData ( 2, "<p class=\"highlighted\">Nos partenaires --- Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque eleifend erat in lectus blandit rutrum. Proin congue hendrerit diam mattis fringilla. Aliquam erat volutpat.</p><p>Proin tristique faucibus ligula a dictum. Etiam at dignissim mi. Mauris magna arcu, varius vitae auctor sed, condimentum eu nisi. Etiam eu diam lacus. Etiam vulputate, nunc non venenatis ornare, nunc arcu euismod mauris, id sagittis quam eros at ex. Nulla viverra leo viverra scelerisque gravida. Cras semper erat vel odio facilisis, et efficitur magna dapibus.</p>" );
				array_push ( $items, $item );
				
				$item = new DatalistItem ();
				$item->key = "partners";
				$item->data = $this->getList ( "partners" );
				array_push ( $items, $item );
				$this->common ( $items );
				
				break;
			default :
				$this->common ( $items );
		}
		
		return $items;
	}
}
?>
