<?php

namespace xo\cms;

use xo\content\ContentService;

class DataList {
	public $id;
	private $service;
	public function __construct(ContentService $service, $id) {
		$this->service = $service;
		$this->id = $id;
	}
	public function size($withDeleted=true) {
		return $this->service->getListSize ( $this->id,$withDeleted );
	}
	public function get($key) {
		$keys = array_reverse ( explode ( "/", $key ) );
		$k = array_pop ( $keys );
		$tmp = $this->getItemFromKey ( $k );
		while ( count ( $keys ) > 0 && $tmp != null ) {
			$k = array_pop ( $keys );
			$tmp = $tmp->data->get ( $k );
		}
		return $tmp;
	}
	public function getItems($load = true, $offset = 0, $limit = 500, $withDeleted = true) {
		return $this->service->getListItems ( $this->id, $load, $offset, $limit, $withDeleted );
	}
	public function getItemFromKey($key, $withDeleted = true) {
		return $this->service->getListItemFromKey ( $this->id, $key, $withDeleted );
	}
}

?>
