<?php

namespace xo\cms\core;

use \PDO;

class Configuration {
	private static $INSTANCE;
	private $env;
	private $params = null;
	private $rootPath;
	static public function getInstance() {
		if (self::$INSTANCE == null) {
			self::$INSTANCE = new Configuration ();
		}
		return self::$INSTANCE;
	}
	private function __construct() {
		$this->env = 'prod';
	}
	public function setEnv($env) {
		$this->env = $env;
	}
	public function getLessFile($filename) {
		return "$this->rootPath/template/less/$filename";
	}
	public function getDataDir() {
		return "$this->rootPath/var/data";
	}
	public function getCacheDir() {
		return "$this->rootPath/var/cache";
	}
	public function getTempDirectoryPath() {
		$tmpDir = "$this->rootPath/var/tmp";
		if (file_exists ( $tmpDir )) {
			$old_umask = umask ( 0 );
			mkdir ( $tmpDir, 0750 );
			umask ( $old_umask );
		}
		return $tmpDir;
	}
	public function getWebPagePreviewData() {
		$filename = "{$this->rootPath}/configuration/default-webpage-preview.png";
		if (file_exists ( $filename )) {
			return file_get_contents ( $filename );
		} else {
			return base64_decode ( "iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AUREQoFbbTb6gAAABl0RVh0Q29tbWVudABDcmVhdGVkIHdpdGggR0lNUFeBDhcAAADtSURBVHja7dIBDQAACMMwwL/nY4OEVsKyTlL8NRIYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEMIIEBMAAGwAAYAANgAAyAATAABsAAGAADYAAMgAEwAAbAABgAA2AADIABMAAGwAAYAANgAAyAATAABsAAGAADYAAMwA0L7XcD/RiEY4cAAAAASUVORK5CYII=" );
		}
	}
	public function load($rootPath) {
		if ($this->params == null) {
			$this->rootPath = $rootPath;
			$configFile = "$this->rootPath/configuration/config-$this->env.ini";
			$this->params = parse_ini_file ( $configFile, true );
		}
	}
	public function getCookiesDomain() {
		return $this->params ['cookies'] ['domain'];
	}
	public function getSessionName() {
		return $this->params ['session'] ['name'];
	}
	public function db($name = 'cms') {
		$dbConfig = $this->params ['db'] [$name];
		$host = $dbConfig ['host'];
		$dbname = $dbConfig ['dbname'];
		$user = $dbConfig ['user'];
		$password = $dbConfig ['password'];
		$pdo = new PDO ( "mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password );
		$pdo->setAttribute ( PDO::ATTR_EMULATE_PREPARES, false );
		$pdo->setAttribute ( PDO::ATTR_PERSISTENT, true );
		return $pdo;
	}
}

?>
