<?php

namespace xo\authtoken;

class AuthTokenService {
	private $db;
	public function __construct($db) {
		$this->db = $db;
	}
	public static function uuid() {
		return hex2bin ( sprintf ( '%04x%04x%04x%04x%04x%04x%04x%04x', mt_rand ( 0, 0xffff ), mt_rand ( 0, 0xffff ), mt_rand ( 0, 0xffff ), mt_rand ( 0, 0x0fff ) | 0x4000, mt_rand ( 0, 0x3fff ) | 0x8000, mt_rand ( 0, 0xffff ), mt_rand ( 0, 0xffff ), mt_rand ( 0, 0xffff ) ) );
	}
	public function createToken($authCode, $payLoad, $since, $until) {
		$token = new AuthToken ( AuthTokenService::uuid (), $authCode, $payLoad, $since, $until );
		self::createAuthTokenRow ( $this->db, $token->getToken (), $authCode, $payLoad, $since, $until );
		return $token;
	}
	private static function createAuthTokenRow($db, $token, $authCode, $payLoad, $since, $until) {
		try {
			
			
			$query = 'insert into AUTHTOKEN_TOKEN(token,valid_since,valid_until,auth_code,pay_load) values(:token,FROM_UNIXTIME(:since),FROM_UNIXTIME(:until),:auth_code,:pay_load)';
			$stmt = $db->prepare ( $query );
			
			
			$stmt->bindValue ( ":token", $token );
			$stmt->bindValue ( ":since", $since );
			$stmt->bindValue ( ":until", $until );
			$stmt->bindValue ( ":auth_code", $authCode );
			$stmt->bindValue ( ":pay_load", $payLoad );
			$stmt->execute ();
			
		} catch ( Exception $e ) {
			error_log ( $e->getMessage () );
			throw new ServiceFunctionalException ( "Une erreur est survenue." );
		}
	}
	public function getToken($tokenStr) {
		$token = hex2bin ( $tokenStr );
		$row = $this->getAuthTokenRow ( $token );
		$authToken = new AuthToken ( $token, $row ['AUTH_CODE'], $row ['PAY_LOAD'], strtotime($row ['VALID_SINCE']) , strtotime($row ['VALID_UNTIL']) );
		return $authToken;
	}
	private function getAuthTokenRow($token) {
		try {
			$query = "select * from AUTHTOKEN_TOKEN where TOKEN=?";
			$stmt = $this->db->prepare ( $query );
			$stmt->execute ( array (
					$token 
			) );
			return $stmt->fetch ();
		} catch ( Exception $e ) {
			error_log ( $e->getMessage () );
			throw new ServiceFunctionalException ( "Une erreur est survenue." );
		}
	}
}
?>