DROP TABLE CONTENT_WEBSITE_V2;
DROP TABLE CONTENT_RESOURCE_V2;
DROP TABLE CONTENT_RESOURCE_VERSION_V2;
DROP TABLE CONTENT_WEBPAGE_V2;
DROP TABLE CONTENT_RESOURCE_REF_V2;
DROP TABLE CONTENT_RESOURCE_MAP_V2;
DROP TABLE CONTENT_LIST_ITEM_V2;
DROP TABLE CONTENT_DATA_V2;

-- Tables

CREATE TABLE  CONTENT_WEBSITE_V2(
	id binary(16) not null,
	online bool not null,
	url text not null,
	data_list_id binary(16) not null
);

CREATE TABLE  CONTENT_RESOURCE_V2(
	id binary(16)  not null,
	i18n_code binary(16)  not null,
	locale char(2) not null,
	creation_date int(8) not null,
	path_id binary(16)  not null
);
CREATE TABLE  CONTENT_RESOURCE_VERSION_V2(
	resource_id binary(16)  not null,
	version int(8)  not null,
	data_id binary(16)  not null,
	data_preview_id binary(16)  ,
	name varchar(250) not null,
	description text,
	comment varchar(250),
	current_version bool not null
);
CREATE TABLE  CONTENT_DATA_V2(
	id binary(16)  not null,
	content_type varchar(50) not null,
	filename varchar(80) not null,
	date int(8) not null,
	charset varchar(20) null,
	encoding varchar(8) not null,
	md5 binary(16),
	length int(8)
);


CREATE TABLE  CONTENT_WEBPAGE_V2(
	id binary(16)  not null,
	template text not null,
	data_list_id binary(16) not null,
	seo_title varchar(80),
	seo_description varchar(250),
	seo_img_id binary(16),
	parameters text
);

CREATE TABLE  CONTENT_RESOURCE_REF_V2(
	id binary(16) not null,
	comment text,
	label text,	
	description text,
	title text,
	img_id binary(16),
	img_over_id binary(16),
	img_alt text,
	path_id binary(16),
	url text
);

CREATE TABLE  CONTENT_RESOURCE_MAP_V2(
	id binary(16) not null,
	resource_id binary(16) not null,
	path varchar(256) not null,
	online bool not null
);

CREATE TABLE  CONTENT_LIST_ITEM_V2(
	id binary(16),
	list_id binary(16) not null,
	idx int(8) not null,
	`key` varchar(75),
	value_resource_id binary(16),
	value_resource_ref_id binary(16),
	value_list_id binary(16)
);

-- Constraints
ALTER TABLE  CONTENT_WEBSITE_V2 ADD PRIMARY KEY(id);

ALTER TABLE CONTENT_RESOURCE_V2 ADD PRIMARY KEY( id);
ALTER TABLE CONTENT_RESOURCE_V2 ADD UNIQUE(i18n_code,locale);


ALTER TABLE CONTENT_RESOURCE_VERSION_V2 ADD PRIMARY KEY( resource_id,version);



ALTER TABLE  CONTENT_DATA_V2 ADD PRIMARY KEY(id);
ALTER TABLE  CONTENT_DATA_V2 ADD INDEX(content_type);
ALTER TABLE  CONTENT_DATA_V2 ADD INDEX(charset);
ALTER TABLE  CONTENT_DATA_V2 ADD INDEX(encoding);


ALTER TABLE  CONTENT_WEBPAGE_V2 ADD PRIMARY KEY(id);

ALTER TABLE  CONTENT_RESOURCE_REF_V2 ADD PRIMARY KEY(id);

ALTER TABLE  CONTENT_RESOURCE_MAP_V2 ADD PRIMARY KEY(id);
ALTER TABLE  CONTENT_RESOURCE_MAP_V2 ADD UNIQUE(path);


ALTER TABLE  CONTENT_LIST_ITEM_V2 ADD PRIMARY KEY(id);
-- ALTER TABLE  CONTENT_LIST_ITEM_V2 ADD UNIQUE(list_id,idx);
ALTER TABLE  CONTENT_LIST_ITEM_V2 ADD UNIQUE(list_id,`key`);

-- Data
INSERT INTO CONTENT_WEBSITE_V2 (id, online, url, data_list_id) 
VALUES (0xf193dccd7c2649569fea4cf520083530, 1, 'http://www.v2.fec.fo', 0xe2cf526e46f845b0a5e7cb8d66812238);

