<?php

// >> INCLUDE
$rootPath = dirname ( dirname ( __FILE__ ) );

$includePath = get_include_path ();
$includePathSeparator = PATH_SEPARATOR;
$classPath = "$rootPath/include";
$templatePath = "$rootPath/template";
$includePath = "$includePath$includePathSeparator$classPath$includePathSeparator$templatePath";
set_include_path ( $includePath );

// LOG \\ 
$logFile = "$rootPath/var/log/php-error.log";
error_reporting ( E_ALL );
ini_set ( 'display_errors', 0 ); 
ini_set ( 'log_errors', 1 );
ini_set ( 'error_log', $logFile );
spl_autoload_extensions ( ".class.php" );
spl_autoload_register ();

// Config \\
$config = xo\cms\core\Configuration::getInstance ();
if (isset ( $_SERVER ['DEV_ENV'] )) {
	$config->setEnv ( 'dev' );
}
$config->load ( $rootPath );

ini_set ( 'session.use_cookies', '1' );
ini_set ( 'session.use_only_cookies', '1' ); // évite les attaques avec session id dans l'URL
ini_set ( 'session.use_trans_sid', '0' ); // empêche la propagation des SESSION_ID dans les URL
ini_set ( 'session.hash_function', '1' ); // Hash avec SHA-1 et non pas MD5
ini_set ( 'url_rewriter.tags', '' );

session_set_cookie_params ( 0, '/', $config->getCookiesDomain() );
ini_set('session.name',$config->getSessionName());

date_default_timezone_set ( 'EUROPE/PARIS' );
?>
